@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationAutoStartConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables the application to automatically start on job submission. Defaults to `true`.
 */
public data class ApplicationAutoStartConfigurationArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationAutoStartConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationAutoStartConfigurationArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationAutoStartConfigurationArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAutoStartConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationAutoStartConfigurationArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Enables the application to automatically start on job submission. Defaults to `true`.
     */
    @JvmName("wwomuctchhkjvbpb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enables the application to automatically start on job submission. Defaults to `true`.
     */
    @JvmName("bdoioxpavebhxmtd")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ApplicationAutoStartConfigurationArgs =
        ApplicationAutoStartConfigurationArgs(
            enabled = enabled,
        )
}
