@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu The CPU requirements for every worker instance of the worker type.
 * @property disk The disk requirements for every worker instance of the worker type.
 * @property memory The memory requirements for every worker instance of the worker type.
 */
public data class ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs(
    public val cpu: Output<String>,
    public val disk: Output<String>? = null,
    public val memory: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs.builder()
            .cpu(cpu.applyValue({ args0 -> args0 }))
            .disk(disk?.applyValue({ args0 -> args0 }))
            .memory(memory.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgsBuilder internal
constructor() {
    private var cpu: Output<String>? = null

    private var disk: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value The CPU requirements for every worker instance of the worker type.
     */
    @JvmName("wjvosgupgrdvksjf")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value The disk requirements for every worker instance of the worker type.
     */
    @JvmName("nmepxqltevqfngfe")
    public suspend fun disk(`value`: Output<String>) {
        this.disk = value
    }

    /**
     * @param value The memory requirements for every worker instance of the worker type.
     */
    @JvmName("qmoisierobjkpqvh")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value The CPU requirements for every worker instance of the worker type.
     */
    @JvmName("opkxywnfuvocayqs")
    public suspend fun cpu(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The disk requirements for every worker instance of the worker type.
     */
    @JvmName("npmxkpnopxqrjapp")
    public suspend fun disk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disk = mapped
    }

    /**
     * @param value The memory requirements for every worker instance of the worker type.
     */
    @JvmName("xcgeeoliseexkkac")
    public suspend fun memory(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs =
        ApplicationInitialCapacityInitialCapacityConfigWorkerConfigurationArgs(
            cpu = cpu ?: throw PulumiNullFieldException("cpu"),
            disk = disk,
            memory = memory ?: throw PulumiNullFieldException("memory"),
        )
}
