@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.inputs

import com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cpu The maximum allowed CPU for an application.
 * @property disk The maximum allowed disk for an application.
 * @property memory The maximum allowed resources for an application.
 */
public data class ApplicationMaximumCapacityArgs(
    public val cpu: Output<String>,
    public val disk: Output<String>? = null,
    public val memory: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs> {
    override fun toJava(): com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs =
        com.pulumi.aws.emrserverless.inputs.ApplicationMaximumCapacityArgs.builder()
            .cpu(cpu.applyValue({ args0 -> args0 }))
            .disk(disk?.applyValue({ args0 -> args0 }))
            .memory(memory.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationMaximumCapacityArgs].
 */
@PulumiTagMarker
public class ApplicationMaximumCapacityArgsBuilder internal constructor() {
    private var cpu: Output<String>? = null

    private var disk: Output<String>? = null

    private var memory: Output<String>? = null

    /**
     * @param value The maximum allowed CPU for an application.
     */
    @JvmName("thlhfmxcxhpehigg")
    public suspend fun cpu(`value`: Output<String>) {
        this.cpu = value
    }

    /**
     * @param value The maximum allowed disk for an application.
     */
    @JvmName("kttrukptvjgyfqjn")
    public suspend fun disk(`value`: Output<String>) {
        this.disk = value
    }

    /**
     * @param value The maximum allowed resources for an application.
     */
    @JvmName("nwbdljqquynmbjir")
    public suspend fun memory(`value`: Output<String>) {
        this.memory = value
    }

    /**
     * @param value The maximum allowed CPU for an application.
     */
    @JvmName("setofrlnmrhxcdre")
    public suspend fun cpu(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The maximum allowed disk for an application.
     */
    @JvmName("obhdkroumvttwpkl")
    public suspend fun disk(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disk = mapped
    }

    /**
     * @param value The maximum allowed resources for an application.
     */
    @JvmName("ahqltdifwdlthvkj")
    public suspend fun memory(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memory = mapped
    }

    internal fun build(): ApplicationMaximumCapacityArgs = ApplicationMaximumCapacityArgs(
        cpu = cpu ?: throw PulumiNullFieldException("cpu"),
        disk = disk,
        memory = memory ?: throw PulumiNullFieldException("memory"),
    )
}
