@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property enabled Enables the application to automatically stop after a certain amount of time being idle. Defaults to `true`.
 * @property idleTimeoutMinutes The amount of idle time in minutes after which your application will automatically stop. Defaults to `15` minutes.
 */
public data class ApplicationAutoStopConfiguration(
    public val enabled: Boolean? = null,
    public val idleTimeoutMinutes: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationAutoStopConfiguration):
            ApplicationAutoStopConfiguration = ApplicationAutoStopConfiguration(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            idleTimeoutMinutes = javaType.idleTimeoutMinutes().map({ args0 -> args0 }).orElse(null),
        )
    }
}
