@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property initialCapacityConfig The initial capacity configuration per worker.
 * @property initialCapacityType The worker type for an analytics framework. For Spark applications, the key can either be set to `Driver` or `Executor`. For Hive applications, it can be set to `HiveDriver` or `TezTask`.
 */
public data class ApplicationInitialCapacity(
    public val initialCapacityConfig: ApplicationInitialCapacityInitialCapacityConfig? = null,
    public val initialCapacityType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationInitialCapacity):
            ApplicationInitialCapacity = ApplicationInitialCapacity(
            initialCapacityConfig = javaType.initialCapacityConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.emrserverless.kotlin.outputs.ApplicationInitialCapacityInitialCapacityConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            initialCapacityType = javaType.initialCapacityType(),
        )
    }
}
