@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.emrserverless.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds The array of security group Ids for customer VPC connectivity.
 * @property subnetIds The array of subnet Ids for customer VPC connectivity.
 */
public data class ApplicationNetworkConfiguration(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.emrserverless.outputs.ApplicationNetworkConfiguration):
            ApplicationNetworkConfiguration = ApplicationNetworkConfiguration(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
