@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.kotlin.outputs.LaunchExecution
import com.pulumi.aws.evidently.kotlin.outputs.LaunchGroup
import com.pulumi.aws.evidently.kotlin.outputs.LaunchMetricMonitor
import com.pulumi.aws.evidently.kotlin.outputs.LaunchScheduledSplitsConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.evidently.kotlin.outputs.LaunchExecution.Companion.toKotlin as launchExecutionToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchGroup.Companion.toKotlin as launchGroupToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchMetricMonitor.Companion.toKotlin as launchMetricMonitorToKotlin
import com.pulumi.aws.evidently.kotlin.outputs.LaunchScheduledSplitsConfig.Companion.toKotlin as launchScheduledSplitsConfigToKotlin

/**
 * Builder for [Launch].
 */
@PulumiTagMarker
public class LaunchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LaunchArgs = LaunchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LaunchArgsBuilder.() -> Unit) {
        val builder = LaunchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Launch {
        val builtJavaResource = com.pulumi.aws.evidently.Launch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Launch(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Evidently Launch resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .description("example description")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With multiple groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .description("first-group")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .description("second-group")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With metric_monitors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .metricMonitors(
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key1")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}")
 *                         .name("name1")
 *                         .unitLabel("unit_label1")
 *                         .valueKey("value_key1")
 *                         .build())
 *                     .build(),
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key2")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}")
 *                         .name("name2")
 *                         .unitLabel("unit_label2")
 *                         .valueKey("value_key2")
 *                         .build())
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With randomization_salt
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .randomizationSalt("example randomization salt")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With multiple steps
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 15),
 *                             Map.entry("Variation2", 10)
 *                         ))
 *                         .startTime("2024-01-07 01:43:59+00:00")
 *                         .build(),
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 20),
 *                             Map.entry("Variation2", 25)
 *                         ))
 *                         .startTime("2024-01-08 01:43:59+00:00")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With segment overrides
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .segmentOverrides(
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(1)
 *                             .segment(aws_evidently_segment.example().name())
 *                             .weights(Map.of("Variation2", 10000))
 *                             .build(),
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(2)
 *                             .segment(aws_evidently_segment.example().name())
 *                             .weights(Map.ofEntries(
 *                                 Map.entry("Variation1", 40000),
 *                                 Map.entry("Variation2", 30000)
 *                             ))
 *                             .build())
 *                     .startTime("2024-01-08 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * Import using the `name` of the launch and `name` of the project separated by a `:`:
 * ```sh
 *  $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
 * ```
 *  Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * ```sh
 *  $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
 * ```
 *
 */
public class Launch internal constructor(
    override val javaResource: com.pulumi.aws.evidently.Launch,
) : KotlinCustomResource(javaResource, LaunchMapper) {
    /**
     * The ARN of the launch.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the launch is created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the launch.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that contains information about the start and end times of the launch. Detailed below
     */
    public val executions: Output<List<LaunchExecution>>
        get() = javaResource.executions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchExecutionToKotlin(args0)
                })
            })
        })

    /**
     * One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    public val groups: Output<List<LaunchGroup>>
        get() = javaResource.groups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    launchGroupToKotlin(args0)
                })
            })
        })

    /**
     * The date and time that the launch was most recently updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    public val metricMonitors: Output<List<LaunchMetricMonitor>>?
        get() = javaResource.metricMonitors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        launchMetricMonitorToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or ARN of the project that is to contain the new launch.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    public val randomizationSalt: Output<String>?
        get() = javaResource.randomizationSalt().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    public val scheduledSplitsConfig: Output<LaunchScheduledSplitsConfig>?
        get() = javaResource.scheduledSplitsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> launchScheduledSplitsConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The current state of the launch. Valid values are `CREATED`, `UPDATING`, `RUNNING`, `COMPLETED`, and `CANCELLED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * If the launch was stopped, this is the string that was entered by the person who stopped the launch, to explain why it was stopped.
     */
    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of launch.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LaunchMapper : ResourceMapper<Launch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.evidently.Launch::class == javaResource::class

    override fun map(javaResource: Resource): Launch = Launch(
        javaResource as
            com.pulumi.aws.evidently.Launch,
    )
}

/**
 * @see [Launch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Launch].
 */
public suspend fun launch(name: String, block: suspend LaunchResourceBuilder.() -> Unit): Launch {
    val builder = LaunchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Launch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun launch(name: String): Launch {
    val builder = LaunchResourceBuilder()
    builder.name(name)
    return builder.build()
}
