@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.LaunchArgs.builder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchGroupArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchGroupArgsBuilder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchMetricMonitorArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchMetricMonitorArgsBuilder
import com.pulumi.aws.evidently.kotlin.inputs.LaunchScheduledSplitsConfigArgs
import com.pulumi.aws.evidently.kotlin.inputs.LaunchScheduledSplitsConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Evidently Launch resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .description("example description")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With multiple groups
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .description("first-group")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .description("second-group")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With metric_monitors
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .metricMonitors(
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key1")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",11,\"<=\",22]}]}")
 *                         .name("name1")
 *                         .unitLabel("unit_label1")
 *                         .valueKey("value_key1")
 *                         .build())
 *                     .build(),
 *                 LaunchMetricMonitorArgs.builder()
 *                     .metricDefinition(LaunchMetricMonitorMetricDefinitionArgs.builder()
 *                         .entityIdKey("entity_id_key2")
 *                         .eventPattern("{\"Price\":[{\"numeric\":[\">\",9,\"<=\",19]}]}")
 *                         .name("name2")
 *                         .unitLabel("unit_label2")
 *                         .valueKey("value_key2")
 *                         .build())
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With randomization_salt
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .randomizationSalt("example randomization salt")
 *             .groups(LaunchGroupArgs.builder()
 *                 .feature(aws_evidently_feature.example().name())
 *                 .name("Variation1")
 *                 .variation("Variation1")
 *                 .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.of("Variation1", 0))
 *                     .startTime("2024-01-07 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With multiple steps
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 15),
 *                             Map.entry("Variation2", 10)
 *                         ))
 *                         .startTime("2024-01-07 01:43:59+00:00")
 *                         .build(),
 *                     LaunchScheduledSplitsConfigStepArgs.builder()
 *                         .groupWeights(Map.ofEntries(
 *                             Map.entry("Variation1", 20),
 *                             Map.entry("Variation2", 25)
 *                         ))
 *                         .startTime("2024-01-08 01:43:59+00:00")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With segment overrides
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Launch;
 * import com.pulumi.aws.evidently.LaunchArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchGroupArgs;
 * import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Launch("example", LaunchArgs.builder()
 *             .project(aws_evidently_project.example().name())
 *             .groups(
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation1")
 *                     .variation("Variation1")
 *                     .build(),
 *                 LaunchGroupArgs.builder()
 *                     .feature(aws_evidently_feature.example().name())
 *                     .name("Variation2")
 *                     .variation("Variation2")
 *                     .build())
 *             .scheduledSplitsConfig(LaunchScheduledSplitsConfigArgs.builder()
 *                 .steps(LaunchScheduledSplitsConfigStepArgs.builder()
 *                     .groupWeights(Map.ofEntries(
 *                         Map.entry("Variation1", 0),
 *                         Map.entry("Variation2", 0)
 *                     ))
 *                     .segmentOverrides(
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(1)
 *                             .segment(aws_evidently_segment.example().name())
 *                             .weights(Map.of("Variation2", 10000))
 *                             .build(),
 *                         LaunchScheduledSplitsConfigStepSegmentOverrideArgs.builder()
 *                             .evaluationOrder(2)
 *                             .segment(aws_evidently_segment.example().name())
 *                             .weights(Map.ofEntries(
 *                                 Map.entry("Variation1", 40000),
 *                                 Map.entry("Variation2", 30000)
 *                             ))
 *                             .build())
 *                     .startTime("2024-01-08 01:43:59+00:00")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * __Using `pulumi import` to import__ CloudWatch Evidently Launch using the `name` of the launch and `name` of the project or `arn` of the hosting CloudWatch Evidently Project separated by a `:`. For example:
 * Import using the `name` of the launch and `name` of the project separated by a `:`:
 * ```sh
 *  $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:exampleProjectName
 * ```
 *  Import using the `name` of the launch and `arn` of the project separated by a `:`:
 * ```sh
 *  $ pulumi import aws:evidently/launch:Launch example exampleLaunchName:arn:aws:evidently:us-east-1:123456789012:project/exampleProjectName
 * ```
 * @property description Specifies the description of the launch.
 * @property groups One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
 * @property metricMonitors One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
 * @property name The name for the new launch. Minimum length of `1`. Maximum length of `127`.
 * @property project The name or ARN of the project that is to contain the new launch.
 * @property randomizationSalt When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
 * @property scheduledSplitsConfig A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
 * @property tags Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class LaunchArgs(
    public val description: Output<String>? = null,
    public val groups: Output<List<LaunchGroupArgs>>? = null,
    public val metricMonitors: Output<List<LaunchMetricMonitorArgs>>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val randomizationSalt: Output<String>? = null,
    public val scheduledSplitsConfig: Output<LaunchScheduledSplitsConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.LaunchArgs> {
    override fun toJava(): com.pulumi.aws.evidently.LaunchArgs =
        com.pulumi.aws.evidently.LaunchArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .groups(groups?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .metricMonitors(
                metricMonitors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .randomizationSalt(randomizationSalt?.applyValue({ args0 -> args0 }))
            .scheduledSplitsConfig(
                scheduledSplitsConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [LaunchArgs].
 */
@PulumiTagMarker
public class LaunchArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var groups: Output<List<LaunchGroupArgs>>? = null

    private var metricMonitors: Output<List<LaunchMetricMonitorArgs>>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var randomizationSalt: Output<String>? = null

    private var scheduledSplitsConfig: Output<LaunchScheduledSplitsConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the launch.
     */
    @JvmName("jxbmcfnrwmdmurvl")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("jsoixplcawtlandv")
    public suspend fun groups(`value`: Output<List<LaunchGroupArgs>>) {
        this.groups = value
    }

    @JvmName("nfrtrtqcmmoksydu")
    public suspend fun groups(vararg values: Output<LaunchGroupArgs>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("nmkidveseftbbyyd")
    public suspend fun groups(values: List<Output<LaunchGroupArgs>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("vnpvysgqlifjyvuv")
    public suspend fun metricMonitors(`value`: Output<List<LaunchMetricMonitorArgs>>) {
        this.metricMonitors = value
    }

    @JvmName("ebnuejlgxtrkkxpg")
    public suspend fun metricMonitors(vararg values: Output<LaunchMetricMonitorArgs>) {
        this.metricMonitors = Output.all(values.asList())
    }

    /**
     * @param values One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("samrroeamrmttgvt")
    public suspend fun metricMonitors(values: List<Output<LaunchMetricMonitorArgs>>) {
        this.metricMonitors = Output.all(values)
    }

    /**
     * @param value The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("dwcjvmgxcftvvyol")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or ARN of the project that is to contain the new launch.
     */
    @JvmName("jkjvlosqxedrmmnb")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    @JvmName("lgvyogtsbidlnrpo")
    public suspend fun randomizationSalt(`value`: Output<String>) {
        this.randomizationSalt = value
    }

    /**
     * @param value A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("juqvsqqtguhenawe")
    public suspend fun scheduledSplitsConfig(`value`: Output<LaunchScheduledSplitsConfigArgs>) {
        this.scheduledSplitsConfig = value
    }

    /**
     * @param value Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qxmqedhisuipgjbw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the launch.
     */
    @JvmName("erhydcntcndslufv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("eimthqildriviela")
    public suspend fun groups(`value`: List<LaunchGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("cyrnwearsakswvht")
    public suspend fun groups(argument: List<suspend LaunchGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { LaunchGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("gipfucypkfkvfvum")
    public suspend fun groups(vararg argument: suspend LaunchGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { LaunchGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("idxytlfkggyuyfat")
    public suspend fun groups(argument: suspend LaunchGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LaunchGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param values One or up to five blocks that contain the feature and variations that are to be used for the launch. Detailed below.
     */
    @JvmName("ylgdclbvotjqyaxg")
    public suspend fun groups(vararg values: LaunchGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("migypwsdwujhqgws")
    public suspend fun metricMonitors(`value`: List<LaunchMetricMonitorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("bbtiykntltdwqdno")
    public suspend
    fun metricMonitors(argument: List<suspend LaunchMetricMonitorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchMetricMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("ccjgamtefdfglyxa")
    public suspend fun metricMonitors(
        vararg
        argument: suspend LaunchMetricMonitorArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LaunchMetricMonitorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param argument One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("hedkdyuirtevaoej")
    public suspend fun metricMonitors(argument: suspend LaunchMetricMonitorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LaunchMetricMonitorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.metricMonitors = mapped
    }

    /**
     * @param values One or up to three blocks that define the metrics that will be used to monitor the launch performance. Detailed below.
     */
    @JvmName("wtawgbdegdjffoli")
    public suspend fun metricMonitors(vararg values: LaunchMetricMonitorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricMonitors = mapped
    }

    /**
     * @param value The name for the new launch. Minimum length of `1`. Maximum length of `127`.
     */
    @JvmName("drwuyuwsrsvymrhr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or ARN of the project that is to contain the new launch.
     */
    @JvmName("jvhegtuqxsaoivty")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value When Evidently assigns a particular user session to a launch, it must use a randomization ID to determine which variation the user session is served. This randomization ID is a combination of the entity ID and randomizationSalt. If you omit randomizationSalt, Evidently uses the launch name as the randomizationSalt.
     */
    @JvmName("hhqweyaqpyqmgpwh")
    public suspend fun randomizationSalt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.randomizationSalt = mapped
    }

    /**
     * @param value A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("hgayhuvjnkauxqmm")
    public suspend fun scheduledSplitsConfig(`value`: LaunchScheduledSplitsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledSplitsConfig = mapped
    }

    /**
     * @param argument A block that defines the traffic allocation percentages among the feature variations during each step of the launch. Detailed below.
     */
    @JvmName("pjdxoyusesmgcgrb")
    public suspend
    fun scheduledSplitsConfig(argument: suspend LaunchScheduledSplitsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchScheduledSplitsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scheduledSplitsConfig = mapped
    }

    /**
     * @param value Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ryornupvdygvfdbr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the launch. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nehoyumekxhmqmmk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): LaunchArgs = LaunchArgs(
        description = description,
        groups = groups,
        metricMonitors = metricMonitors,
        name = name,
        project = project,
        randomizationSalt = randomizationSalt,
        scheduledSplitsConfig = scheduledSplitsConfig,
        tags = tags,
    )
}
