@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.aws.evidently.ProjectArgs.builder
import com.pulumi.aws.evidently.kotlin.inputs.ProjectDataDeliveryArgs
import com.pulumi.aws.evidently.kotlin.inputs.ProjectDataDeliveryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CloudWatch Evidently Project resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .description("Example Description")
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ### Store evaluation events in a CloudWatch Log Group
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryCloudwatchLogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .dataDelivery(ProjectDataDeliveryArgs.builder()
 *                 .cloudwatchLogs(ProjectDataDeliveryCloudwatchLogsArgs.builder()
 *                     .logGroup("example-log-group-name")
 *                     .build())
 *                 .build())
 *             .description("Example Description")
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ### Store evaluation events in an S3 bucket
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Project;
 * import com.pulumi.aws.evidently.ProjectArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs;
 * import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .dataDelivery(ProjectDataDeliveryArgs.builder()
 *                 .s3Destination(ProjectDataDeliveryS3DestinationArgs.builder()
 *                     .bucket("example-bucket-name")
 *                     .prefix("example")
 *                     .build())
 *                 .build())
 *             .description("Example Description")
 *             .tags(Map.of("Key1", "example Project"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Project using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:evidently/project:Project example arn:aws:evidently:us-east-1:123456789012:segment/example
 * ```
 * @property dataDelivery A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
 * @property description Specifies the description of the project.
 * @property name A name for the project.
 * @property tags Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ProjectArgs(
    public val dataDelivery: Output<ProjectDataDeliveryArgs>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.evidently.ProjectArgs =
        com.pulumi.aws.evidently.ProjectArgs.builder()
            .dataDelivery(dataDelivery?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var dataDelivery: Output<ProjectDataDeliveryArgs>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
     */
    @JvmName("xyusbbddieygrkvt")
    public suspend fun dataDelivery(`value`: Output<ProjectDataDeliveryArgs>) {
        this.dataDelivery = value
    }

    /**
     * @param value Specifies the description of the project.
     */
    @JvmName("jmlanlknomlmpiis")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A name for the project.
     */
    @JvmName("olofxvtfsjcvrsfu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eihlptfkbgoalhrx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
     */
    @JvmName("drrnfermmdhuvgjo")
    public suspend fun dataDelivery(`value`: ProjectDataDeliveryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDelivery = mapped
    }

    /**
     * @param argument A block that contains information about where Evidently is to store evaluation events for longer term storage, if you choose to do so. If you choose not to store these events, Evidently deletes them after using them to produce metrics and other experiment results that you can view. See below.
     */
    @JvmName("cykwqwcjejcnuabc")
    public suspend fun dataDelivery(argument: suspend ProjectDataDeliveryArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectDataDeliveryArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataDelivery = mapped
    }

    /**
     * @param value Specifies the description of the project.
     */
    @JvmName("wxqbcedurltncboa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A name for the project.
     */
    @JvmName("xlekyatwwurngckl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugoumooyaxdfyneo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the project. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xiaphfddejqxlsia")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        dataDelivery = dataDelivery,
        description = description,
        name = name,
        tags = tags,
    )
}
