@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Segment].
 */
@PulumiTagMarker
public class SegmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SegmentArgs = SegmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SegmentArgsBuilder.() -> Unit) {
        val builder = SegmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Segment {
        val builtJavaResource = com.pulumi.aws.evidently.Segment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Segment(builtJavaResource)
    }
}

/**
 * Provides a CloudWatch Evidently Segment resource.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .pattern("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}")
 *             .tags(Map.of("Key1", "example Segment"))
 *             .build());
 *     }
 * }
 * ```
 * ### With JSON object in pattern
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .pattern("""
 *   {
 *     "Price": [
 *       {
 *         "numeric": [">",10,"<=",20]
 *       }
 *     ]
 *   }
 *             """)
 *             .tags(Map.of("Key1", "example Segment"))
 *             .build());
 *     }
 * }
 * ```
 * ### With Description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.evidently.Segment;
 * import com.pulumi.aws.evidently.SegmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Segment("example", SegmentArgs.builder()
 *             .description("example")
 *             .pattern("{\"Price\":[{\"numeric\":[\">\",10,\"<=\",20]}]}")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import CloudWatch Evidently Segment using the `arn`. For example:
 * ```sh
 *  $ pulumi import aws:evidently/segment:Segment example arn:aws:evidently:us-west-2:123456789012:segment/example
 * ```
 *
 */
public class Segment internal constructor(
    override val javaResource: com.pulumi.aws.evidently.Segment,
) : KotlinCustomResource(javaResource, SegmentMapper) {
    /**
     * The ARN of the segment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time that the segment is created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the segment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of experiments that this segment is used in. This count includes all current experiments, not just those that are currently running.
     */
    public val experimentCount: Output<Int>
        get() = javaResource.experimentCount().applyValue({ args0 -> args0 })

    /**
     * The date and time that this segment was most recently updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * The number of launches that this segment is used in. This count includes all current launches, not just those that are currently running.
     */
    public val launchCount: Output<Int>
        get() = javaResource.launchCount().applyValue({ args0 -> args0 })

    /**
     * A name for the segment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The pattern to use for the segment. For more information about pattern syntax, see [Segment rule pattern syntax](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html).
     */
    public val pattern: Output<String>
        get() = javaResource.pattern().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the segment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SegmentMapper : ResourceMapper<Segment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.evidently.Segment::class == javaResource::class

    override fun map(javaResource: Resource): Segment = Segment(
        javaResource as
            com.pulumi.aws.evidently.Segment,
    )
}

/**
 * @see [Segment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Segment].
 */
public suspend fun segment(name: String, block: suspend SegmentResourceBuilder.() -> Unit):
    Segment {
    val builder = SegmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Segment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun segment(name: String): Segment {
    val builder = SegmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
