@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property metricDefinition A block that defines the metric. Detailed below.
 */
public data class LaunchMetricMonitorArgs(
    public val metricDefinition: Output<LaunchMetricMonitorMetricDefinitionArgs>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs =
        com.pulumi.aws.evidently.inputs.LaunchMetricMonitorArgs.builder()
            .metricDefinition(
                metricDefinition.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [LaunchMetricMonitorArgs].
 */
@PulumiTagMarker
public class LaunchMetricMonitorArgsBuilder internal constructor() {
    private var metricDefinition: Output<LaunchMetricMonitorMetricDefinitionArgs>? = null

    /**
     * @param value A block that defines the metric. Detailed below.
     */
    @JvmName("mtnteuhexqwsamne")
    public suspend fun metricDefinition(`value`: Output<LaunchMetricMonitorMetricDefinitionArgs>) {
        this.metricDefinition = value
    }

    /**
     * @param value A block that defines the metric. Detailed below.
     */
    @JvmName("csshpohragdnvbuu")
    public suspend fun metricDefinition(`value`: LaunchMetricMonitorMetricDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDefinition = mapped
    }

    /**
     * @param argument A block that defines the metric. Detailed below.
     */
    @JvmName("dugeekqtoudpxyqx")
    public suspend
    fun metricDefinition(argument: suspend LaunchMetricMonitorMetricDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = LaunchMetricMonitorMetricDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.metricDefinition = mapped
    }

    internal fun build(): LaunchMetricMonitorArgs = LaunchMetricMonitorArgs(
        metricDefinition = metricDefinition ?: throw PulumiNullFieldException("metricDefinition"),
    )
}
