@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property entityIdKey Specifies the entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is `userDetails.userID`.
 * @property eventPattern Specifies The EventBridge event pattern that defines how the metric is recorded.
 * @property name Specifies the name for the metric.
 * @property unitLabel Specifies a label for the units that the metric is measuring.
 * @property valueKey Specifies the value that is tracked to produce the metric.
 */
public data class LaunchMetricMonitorMetricDefinitionArgs(
    public val entityIdKey: Output<String>,
    public val eventPattern: Output<String>? = null,
    public val name: Output<String>,
    public val unitLabel: Output<String>? = null,
    public val valueKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs =
        com.pulumi.aws.evidently.inputs.LaunchMetricMonitorMetricDefinitionArgs.builder()
            .entityIdKey(entityIdKey.applyValue({ args0 -> args0 }))
            .eventPattern(eventPattern?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .unitLabel(unitLabel?.applyValue({ args0 -> args0 }))
            .valueKey(valueKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LaunchMetricMonitorMetricDefinitionArgs].
 */
@PulumiTagMarker
public class LaunchMetricMonitorMetricDefinitionArgsBuilder internal constructor() {
    private var entityIdKey: Output<String>? = null

    private var eventPattern: Output<String>? = null

    private var name: Output<String>? = null

    private var unitLabel: Output<String>? = null

    private var valueKey: Output<String>? = null

    /**
     * @param value Specifies the entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is `userDetails.userID`.
     */
    @JvmName("tvldsqhywvmpxuko")
    public suspend fun entityIdKey(`value`: Output<String>) {
        this.entityIdKey = value
    }

    /**
     * @param value Specifies The EventBridge event pattern that defines how the metric is recorded.
     */
    @JvmName("iffsdsxkjbalmpkf")
    public suspend fun eventPattern(`value`: Output<String>) {
        this.eventPattern = value
    }

    /**
     * @param value Specifies the name for the metric.
     */
    @JvmName("kchwwcltbusfihxh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies a label for the units that the metric is measuring.
     */
    @JvmName("tprlxhnfygpxpahv")
    public suspend fun unitLabel(`value`: Output<String>) {
        this.unitLabel = value
    }

    /**
     * @param value Specifies the value that is tracked to produce the metric.
     */
    @JvmName("xlqtmafmmfyvehyd")
    public suspend fun valueKey(`value`: Output<String>) {
        this.valueKey = value
    }

    /**
     * @param value Specifies the entity, such as a user or session, that does an action that causes a metric value to be recorded. An example is `userDetails.userID`.
     */
    @JvmName("gwxodfucwtbxtalx")
    public suspend fun entityIdKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entityIdKey = mapped
    }

    /**
     * @param value Specifies The EventBridge event pattern that defines how the metric is recorded.
     */
    @JvmName("gtqtmklwrcoryyhq")
    public suspend fun eventPattern(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventPattern = mapped
    }

    /**
     * @param value Specifies the name for the metric.
     */
    @JvmName("oolkdjbdwykvnord")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies a label for the units that the metric is measuring.
     */
    @JvmName("klffqaihhefsgmft")
    public suspend fun unitLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unitLabel = mapped
    }

    /**
     * @param value Specifies the value that is tracked to produce the metric.
     */
    @JvmName("movudvewrbvlfyla")
    public suspend fun valueKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.valueKey = mapped
    }

    internal fun build(): LaunchMetricMonitorMetricDefinitionArgs =
        LaunchMetricMonitorMetricDefinitionArgs(
            entityIdKey = entityIdKey ?: throw PulumiNullFieldException("entityIdKey"),
            eventPattern = eventPattern,
            name = name ?: throw PulumiNullFieldException("name"),
            unitLabel = unitLabel,
            valueKey = valueKey ?: throw PulumiNullFieldException("valueKey"),
        )
}
