@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property steps One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
 */
public data class LaunchScheduledSplitsConfigArgs(
    public val steps: Output<List<LaunchScheduledSplitsConfigStepArgs>>,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs =
        com.pulumi.aws.evidently.inputs.LaunchScheduledSplitsConfigArgs.builder()
            .steps(
                steps.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [LaunchScheduledSplitsConfigArgs].
 */
@PulumiTagMarker
public class LaunchScheduledSplitsConfigArgsBuilder internal constructor() {
    private var steps: Output<List<LaunchScheduledSplitsConfigStepArgs>>? = null

    /**
     * @param value One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("xmcfqkohqxjiahfn")
    public suspend fun steps(`value`: Output<List<LaunchScheduledSplitsConfigStepArgs>>) {
        this.steps = value
    }

    @JvmName("uqwkcytcbgstmacj")
    public suspend fun steps(vararg values: Output<LaunchScheduledSplitsConfigStepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("jjlagxmpdeyxtnvx")
    public suspend fun steps(values: List<Output<LaunchScheduledSplitsConfigStepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("dlkftrbklydsnobp")
    public suspend fun steps(`value`: List<LaunchScheduledSplitsConfigStepArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("auishsorfxyoittm")
    public suspend
    fun steps(argument: List<suspend LaunchScheduledSplitsConfigStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LaunchScheduledSplitsConfigStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("shkmonvvikodmyyi")
    public suspend fun steps(
        vararg
        argument: suspend LaunchScheduledSplitsConfigStepArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LaunchScheduledSplitsConfigStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("cgmmjsutwkvuyvxy")
    public suspend
    fun steps(argument: suspend LaunchScheduledSplitsConfigStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LaunchScheduledSplitsConfigStepArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values One or up to six blocks that define the traffic allocation percentages among the feature variations during each step of the launch. This also defines the start time of each step. Detailed below.
     */
    @JvmName("pgkhmjnjjvthqpnt")
    public suspend fun steps(vararg values: LaunchScheduledSplitsConfigStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    internal fun build(): LaunchScheduledSplitsConfigArgs = LaunchScheduledSplitsConfigArgs(
        steps = steps ?: throw PulumiNullFieldException("steps"),
    )
}
