@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.inputs

import com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs A block that defines the CloudWatch Log Group that stores the evaluation events. See below.
 * @property s3Destination A block that defines the S3 bucket and prefix that stores the evaluation events. See below.
 */
public data class ProjectDataDeliveryArgs(
    public val cloudwatchLogs: Output<ProjectDataDeliveryCloudwatchLogsArgs>? = null,
    public val s3Destination: Output<ProjectDataDeliveryS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs> {
    override fun toJava(): com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs =
        com.pulumi.aws.evidently.inputs.ProjectDataDeliveryArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectDataDeliveryArgs].
 */
@PulumiTagMarker
public class ProjectDataDeliveryArgsBuilder internal constructor() {
    private var cloudwatchLogs: Output<ProjectDataDeliveryCloudwatchLogsArgs>? = null

    private var s3Destination: Output<ProjectDataDeliveryS3DestinationArgs>? = null

    /**
     * @param value A block that defines the CloudWatch Log Group that stores the evaluation events. See below.
     */
    @JvmName("ildcahymckonktsp")
    public suspend fun cloudwatchLogs(`value`: Output<ProjectDataDeliveryCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value A block that defines the S3 bucket and prefix that stores the evaluation events. See below.
     */
    @JvmName("pexmepfamyudfwyi")
    public suspend fun s3Destination(`value`: Output<ProjectDataDeliveryS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value A block that defines the CloudWatch Log Group that stores the evaluation events. See below.
     */
    @JvmName("cjqtbnjjsfoaqeag")
    public suspend fun cloudwatchLogs(`value`: ProjectDataDeliveryCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument A block that defines the CloudWatch Log Group that stores the evaluation events. See below.
     */
    @JvmName("eobyqtntyfyruiaq")
    public suspend
    fun cloudwatchLogs(argument: suspend ProjectDataDeliveryCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectDataDeliveryCloudwatchLogsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value A block that defines the S3 bucket and prefix that stores the evaluation events. See below.
     */
    @JvmName("iulnmbwlrlcbksch")
    public suspend fun s3Destination(`value`: ProjectDataDeliveryS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument A block that defines the S3 bucket and prefix that stores the evaluation events. See below.
     */
    @JvmName("qfbdtbksicsijadc")
    public suspend
    fun s3Destination(argument: suspend ProjectDataDeliveryS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectDataDeliveryS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): ProjectDataDeliveryArgs = ProjectDataDeliveryArgs(
        cloudwatchLogs = cloudwatchLogs,
        s3Destination = s3Destination,
    )
}
