@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property boolValue If this feature uses the Boolean variation type, this field contains the Boolean value of this variation.
 * @property doubleValue If this feature uses the double integer variation type, this field contains the double integer value of this variation.
 * @property longValue If this feature uses the long variation type, this field contains the long value of this variation. Minimum value of `-9007199254740991`. Maximum value of `9007199254740991`.
 * @property stringValue If this feature uses the string variation type, this field contains the string value of this variation. Minimum length of `0`. Maximum length of `512`.
 */
public data class FeatureVariationValue(
    public val boolValue: String? = null,
    public val doubleValue: String? = null,
    public val longValue: String? = null,
    public val stringValue: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.FeatureVariationValue):
            FeatureVariationValue = FeatureVariationValue(
            boolValue = javaType.boolValue().map({ args0 -> args0 }).orElse(null),
            doubleValue = javaType.doubleValue().map({ args0 -> args0 }).orElse(null),
            longValue = javaType.longValue().map({ args0 -> args0 }).orElse(null),
            stringValue = javaType.stringValue().map({ args0 -> args0 }).orElse(null),
        )
    }
}
