@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endedTime The date and time that the launch ended.
 * @property startedTime The date and time that the launch started.
 */
public data class LaunchExecution(
    public val endedTime: String? = null,
    public val startedTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.LaunchExecution): LaunchExecution =
            LaunchExecution(
                endedTime = javaType.endedTime().map({ args0 -> args0 }).orElse(null),
                startedTime = javaType.startedTime().map({ args0 -> args0 }).orElse(null),
            )
    }
}
