@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Specifies the description of the launch group.
 * @property feature Specifies the name of the feature that the launch is using.
 * @property name Specifies the name of the lahnch group.
 * @property variation Specifies the feature variation to use for this launch group.
 */
public data class LaunchGroup(
    public val description: String? = null,
    public val feature: String,
    public val name: String,
    public val variation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.LaunchGroup): LaunchGroup =
            LaunchGroup(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                feature = javaType.feature(),
                name = javaType.name(),
                variation = javaType.variation(),
            )
    }
}
