@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property groupWeights The traffic allocation percentages among the feature variations during one step of a launch. This is a set of key-value pairs. The keys are variation names. The values represent the percentage of traffic to allocate to that variation during this step. For more information, refer to the [AWS documentation for ScheduledSplitConfig groupWeights](https://docs.aws.amazon.com/cloudwatchevidently/latest/APIReference/API_ScheduledSplitConfig.html).
 * @property segmentOverrides One or up to six blocks that specify different traffic splits for one or more audience segments. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age. Detailed below.
 * @property startTime Specifies the date and time that this step of the launch starts.
 */
public data class LaunchScheduledSplitsConfigStep(
    public val groupWeights: Map<String, Int>,
    public val segmentOverrides: List<LaunchScheduledSplitsConfigStepSegmentOverride>? = null,
    public val startTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.LaunchScheduledSplitsConfigStep):
            LaunchScheduledSplitsConfigStep = LaunchScheduledSplitsConfigStep(
            groupWeights = javaType.groupWeights().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            segmentOverrides = javaType.segmentOverrides().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.evidently.kotlin.outputs.LaunchScheduledSplitsConfigStepSegmentOverride.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime(),
        )
    }
}
