@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.evidently.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucket The name of the bucket in which Evidently stores evaluation events.
 * @property prefix The bucket prefix in which Evidently stores evaluation events.
 */
public data class ProjectDataDeliveryS3Destination(
    public val bucket: String? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.evidently.outputs.ProjectDataDeliveryS3Destination):
            ProjectDataDeliveryS3Destination = ProjectDataDeliveryS3Destination(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
        )
    }
}
