@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxClusterArgs.builder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterAutoScalingConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterAutoScalingConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCacheStorageConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCacheStorageConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCapacityConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCapacityConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCodeArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterCodeArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterDatabaseArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterDatabaseArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterSavedownStorageConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterSavedownStorageConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterVpcConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxClusterVpcConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Cluster.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.finspace.KxCluster;
 * import com.pulumi.aws.finspace.KxClusterArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCapacityConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs;
 * import com.pulumi.aws.finspace.inputs.KxClusterCodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new KxCluster("example", KxClusterArgs.builder()
 *             .environmentId(aws_finspace_kx_environment.example().id())
 *             .type("HDB")
 *             .releaseLabel("1.0")
 *             .azMode("SINGLE")
 *             .availabilityZoneId("use1-az2")
 *             .capacityConfiguration(KxClusterCapacityConfigurationArgs.builder()
 *                 .nodeType("kx.s.2xlarge")
 *                 .nodeCount(2)
 *                 .build())
 *             .vpcConfiguration(KxClusterVpcConfigurationArgs.builder()
 *                 .vpcId(aws_vpc.test().id())
 *                 .securityGroupIds(aws_security_group.example().id())
 *                 .subnetIds(aws_subnet.example().id())
 *                 .ipAddressType("IP_V4")
 *                 .build())
 *             .cacheStorageConfigurations(KxClusterCacheStorageConfigurationArgs.builder()
 *                 .type("CACHE_1000")
 *                 .size(1200)
 *                 .build())
 *             .databases(KxClusterDatabaseArgs.builder()
 *                 .databaseName(aws_finspace_kx_database.example().name())
 *                 .cacheConfiguration(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .build())
 *             .code(KxClusterCodeArgs.builder()
 *                 .s3Bucket(aws_s3_bucket.test().id())
 *                 .s3Key(aws_s3_object.object().key())
 *                 .build())
 *             .timeouts(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Cluster using the `id` (environment ID and cluster name, comma-delimited). For example:
 * ```sh
 *  $ pulumi import aws:finspace/kxCluster:KxCluster example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-cluster
 * ```
 * @property autoScalingConfiguration Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
 * @property availabilityZoneId The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
 * @property azMode The number of availability zones you want to assign per cluster. This can be one of the following:
 * * SINGLE - Assigns one availability zone per cluster.
 * * MULTI - Assigns all the availability zones per cluster.
 * @property cacheStorageConfigurations Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
 * @property capacityConfiguration Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
 * @property code Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
 * @property commandLineArguments List of key-value pairs to make available inside the cluster.
 * @property databases KX database that will be available for querying. Defined below.
 * @property description Description of the cluster.
 * @property environmentId Unique identifier for the KX environment.
 * @property executionRole An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
 * @property initializationScript Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
 * @property name Unique name for the cluster that you want to create.
 * @property releaseLabel Version of FinSpace Managed kdb to run.
 * @property savedownStorageConfiguration Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of KDB database. The following types are available:
 * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
 * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
 * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
 * @property vpcConfiguration Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
 * The following arguments are optional:
 */
public data class KxClusterArgs(
    public val autoScalingConfiguration: Output<KxClusterAutoScalingConfigurationArgs>? = null,
    public val availabilityZoneId: Output<String>? = null,
    public val azMode: Output<String>? = null,
    public val cacheStorageConfigurations: Output<List<KxClusterCacheStorageConfigurationArgs>>? =
        null,
    public val capacityConfiguration: Output<KxClusterCapacityConfigurationArgs>? = null,
    public val code: Output<KxClusterCodeArgs>? = null,
    public val commandLineArguments: Output<Map<String, String>>? = null,
    public val databases: Output<List<KxClusterDatabaseArgs>>? = null,
    public val description: Output<String>? = null,
    public val environmentId: Output<String>? = null,
    public val executionRole: Output<String>? = null,
    public val initializationScript: Output<String>? = null,
    public val name: Output<String>? = null,
    public val releaseLabel: Output<String>? = null,
    public val savedownStorageConfiguration: Output<KxClusterSavedownStorageConfigurationArgs>? =
        null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpcConfiguration: Output<KxClusterVpcConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxClusterArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxClusterArgs =
        com.pulumi.aws.finspace.KxClusterArgs.builder()
            .autoScalingConfiguration(
                autoScalingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .availabilityZoneId(availabilityZoneId?.applyValue({ args0 -> args0 }))
            .azMode(azMode?.applyValue({ args0 -> args0 }))
            .cacheStorageConfigurations(
                cacheStorageConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .capacityConfiguration(
                capacityConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .code(code?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .commandLineArguments(
                commandLineArguments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .databases(
                databases?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .executionRole(executionRole?.applyValue({ args0 -> args0 }))
            .initializationScript(initializationScript?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .releaseLabel(releaseLabel?.applyValue({ args0 -> args0 }))
            .savedownStorageConfiguration(
                savedownStorageConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpcConfiguration(
                vpcConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KxClusterArgs].
 */
@PulumiTagMarker
public class KxClusterArgsBuilder internal constructor() {
    private var autoScalingConfiguration: Output<KxClusterAutoScalingConfigurationArgs>? = null

    private var availabilityZoneId: Output<String>? = null

    private var azMode: Output<String>? = null

    private var cacheStorageConfigurations: Output<List<KxClusterCacheStorageConfigurationArgs>>? =
        null

    private var capacityConfiguration: Output<KxClusterCapacityConfigurationArgs>? = null

    private var code: Output<KxClusterCodeArgs>? = null

    private var commandLineArguments: Output<Map<String, String>>? = null

    private var databases: Output<List<KxClusterDatabaseArgs>>? = null

    private var description: Output<String>? = null

    private var environmentId: Output<String>? = null

    private var executionRole: Output<String>? = null

    private var initializationScript: Output<String>? = null

    private var name: Output<String>? = null

    private var releaseLabel: Output<String>? = null

    private var savedownStorageConfiguration: Output<KxClusterSavedownStorageConfigurationArgs>? =
        null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpcConfiguration: Output<KxClusterVpcConfigurationArgs>? = null

    /**
     * @param value Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     */
    @JvmName("yruqjkgthiswlhmw")
    public suspend
    fun autoScalingConfiguration(`value`: Output<KxClusterAutoScalingConfigurationArgs>) {
        this.autoScalingConfiguration = value
    }

    /**
     * @param value The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     */
    @JvmName("yluigoryklskkfkm")
    public suspend fun availabilityZoneId(`value`: Output<String>) {
        this.availabilityZoneId = value
    }

    /**
     * @param value The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     */
    @JvmName("wbksixgsuywyekms")
    public suspend fun azMode(`value`: Output<String>) {
        this.azMode = value
    }

    /**
     * @param value Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("gyptivxpwuwscjvj")
    public suspend
    fun cacheStorageConfigurations(`value`: Output<List<KxClusterCacheStorageConfigurationArgs>>) {
        this.cacheStorageConfigurations = value
    }

    @JvmName("aaoirsdphmqwlpip")
    public suspend fun cacheStorageConfigurations(
        vararg
        values: Output<KxClusterCacheStorageConfigurationArgs>,
    ) {
        this.cacheStorageConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("dshirltpbqhqurcu")
    public suspend
    fun cacheStorageConfigurations(values: List<Output<KxClusterCacheStorageConfigurationArgs>>) {
        this.cacheStorageConfigurations = Output.all(values)
    }

    /**
     * @param value Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     */
    @JvmName("bnpfsrqtmghypsnu")
    public suspend fun capacityConfiguration(`value`: Output<KxClusterCapacityConfigurationArgs>) {
        this.capacityConfiguration = value
    }

    /**
     * @param value Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     */
    @JvmName("mablaryguriyblgv")
    public suspend fun code(`value`: Output<KxClusterCodeArgs>) {
        this.code = value
    }

    /**
     * @param value List of key-value pairs to make available inside the cluster.
     */
    @JvmName("ksjnweoftlfysfhy")
    public suspend fun commandLineArguments(`value`: Output<Map<String, String>>) {
        this.commandLineArguments = value
    }

    /**
     * @param value KX database that will be available for querying. Defined below.
     */
    @JvmName("fogkonmfkjttvirs")
    public suspend fun databases(`value`: Output<List<KxClusterDatabaseArgs>>) {
        this.databases = value
    }

    @JvmName("vgphoqafhfpoyyxs")
    public suspend fun databases(vararg values: Output<KxClusterDatabaseArgs>) {
        this.databases = Output.all(values.asList())
    }

    /**
     * @param values KX database that will be available for querying. Defined below.
     */
    @JvmName("nawoviivgcgnitul")
    public suspend fun databases(values: List<Output<KxClusterDatabaseArgs>>) {
        this.databases = Output.all(values)
    }

    /**
     * @param value Description of the cluster.
     */
    @JvmName("jeisxyqeduvnxdfr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("mpeyllebqasaykyo")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     */
    @JvmName("imqeikpjjdvtabpj")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     */
    @JvmName("bjggywsrboadxpho")
    public suspend fun initializationScript(`value`: Output<String>) {
        this.initializationScript = value
    }

    /**
     * @param value Unique name for the cluster that you want to create.
     */
    @JvmName("tdqwqcrgchifnwux")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Version of FinSpace Managed kdb to run.
     */
    @JvmName("oxtiddkbioyjcypq")
    public suspend fun releaseLabel(`value`: Output<String>) {
        this.releaseLabel = value
    }

    /**
     * @param value Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     */
    @JvmName("tqpencqohedkhaqg")
    public suspend
    fun savedownStorageConfiguration(`value`: Output<KxClusterSavedownStorageConfigurationArgs>) {
        this.savedownStorageConfiguration = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("undtkcpihsvtbkxd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     */
    @JvmName("siyriqsboccfkaqc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * The following arguments are optional:
     */
    @JvmName("fyjpmrvxtoruruif")
    public suspend fun vpcConfiguration(`value`: Output<KxClusterVpcConfigurationArgs>) {
        this.vpcConfiguration = value
    }

    /**
     * @param value Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     */
    @JvmName("evinfjnvuijomxba")
    public suspend fun autoScalingConfiguration(`value`: KxClusterAutoScalingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingConfiguration = mapped
    }

    /**
     * @param argument Configuration based on which FinSpace will scale in or scale out nodes in your cluster. See auto_scaling_configuration.
     */
    @JvmName("xxdlcxmbwnrpprku")
    public suspend
    fun autoScalingConfiguration(argument: suspend KxClusterAutoScalingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxClusterAutoScalingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.autoScalingConfiguration = mapped
    }

    /**
     * @param value The availability zone identifiers for the requested regions. Required when `az_mode` is set to SINGLE.
     */
    @JvmName("hqapeegpwleapdic")
    public suspend fun availabilityZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneId = mapped
    }

    /**
     * @param value The number of availability zones you want to assign per cluster. This can be one of the following:
     * * SINGLE - Assigns one availability zone per cluster.
     * * MULTI - Assigns all the availability zones per cluster.
     */
    @JvmName("gafonhttvgpscueu")
    public suspend fun azMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azMode = mapped
    }

    /**
     * @param value Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("sdbtbwsryjlroaim")
    public suspend
    fun cacheStorageConfigurations(`value`: List<KxClusterCacheStorageConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheStorageConfigurations = mapped
    }

    /**
     * @param argument Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("hnwjgyjxbblensiw")
    public suspend
    fun cacheStorageConfigurations(argument: List<suspend KxClusterCacheStorageConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxClusterCacheStorageConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheStorageConfigurations = mapped
    }

    /**
     * @param argument Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("nirwcosxtyrgrhdd")
    public suspend fun cacheStorageConfigurations(
        vararg
        argument: suspend KxClusterCacheStorageConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KxClusterCacheStorageConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheStorageConfigurations = mapped
    }

    /**
     * @param argument Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("eauydaelyvblgiav")
    public suspend
    fun cacheStorageConfigurations(argument: suspend KxClusterCacheStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxClusterCacheStorageConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cacheStorageConfigurations = mapped
    }

    /**
     * @param values Configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. See cache_storage_configuration.
     */
    @JvmName("rxipautsrymfuxpl")
    public suspend fun cacheStorageConfigurations(
        vararg
        values: KxClusterCacheStorageConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheStorageConfigurations = mapped
    }

    /**
     * @param value Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     */
    @JvmName("oxwpikvhtogakdrb")
    public suspend fun capacityConfiguration(`value`: KxClusterCapacityConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityConfiguration = mapped
    }

    /**
     * @param argument Structure for the metadata of a cluster. Includes information like the CPUs needed, memory of instances, and number of instances. See capacity_configuration.
     */
    @JvmName("fuiimdpjcgudvnve")
    public suspend
    fun capacityConfiguration(argument: suspend KxClusterCapacityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxClusterCapacityConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacityConfiguration = mapped
    }

    /**
     * @param value Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     */
    @JvmName("ykswtphiqcsmtgwy")
    public suspend fun code(`value`: KxClusterCodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param argument Details of the custom code that you want to use inside a cluster when analyzing data. Consists of the S3 source bucket, location, object version, and the relative path from where the custom code is loaded into the cluster. See code.
     */
    @JvmName("mfsfcujucxolksys")
    public suspend fun code(argument: suspend KxClusterCodeArgsBuilder.() -> Unit) {
        val toBeMapped = KxClusterCodeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.code = mapped
    }

    /**
     * @param value List of key-value pairs to make available inside the cluster.
     */
    @JvmName("iinlgnlvqdgyvycv")
    public suspend fun commandLineArguments(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commandLineArguments = mapped
    }

    /**
     * @param values List of key-value pairs to make available inside the cluster.
     */
    @JvmName("coifrbdbalwyjltl")
    public fun commandLineArguments(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commandLineArguments = mapped
    }

    /**
     * @param value KX database that will be available for querying. Defined below.
     */
    @JvmName("kljbqgwpcolnuxjw")
    public suspend fun databases(`value`: List<KxClusterDatabaseArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param argument KX database that will be available for querying. Defined below.
     */
    @JvmName("qklvnlfjfpqwqhfy")
    public suspend fun databases(argument: List<suspend KxClusterDatabaseArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument KX database that will be available for querying. Defined below.
     */
    @JvmName("kwmlahhlyrndmhdd")
    public suspend fun databases(vararg argument: suspend KxClusterDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param argument KX database that will be available for querying. Defined below.
     */
    @JvmName("jrypyfcvxbwrufrv")
    public suspend fun databases(argument: suspend KxClusterDatabaseArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KxClusterDatabaseArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.databases = mapped
    }

    /**
     * @param values KX database that will be available for querying. Defined below.
     */
    @JvmName("nbxixndqdbyhlgnc")
    public suspend fun databases(vararg values: KxClusterDatabaseArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param value Description of the cluster.
     */
    @JvmName("gqbecpywnmdljcpq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("nudrsyoulobnhiab")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.
     */
    @JvmName("ncvktwqtxxstlunc")
    public suspend fun executionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value Path to Q program that will be run at launch of a cluster. This is a relative path within .zip file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, somedir/init.q.
     */
    @JvmName("abqajiurkpmxujwt")
    public suspend fun initializationScript(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializationScript = mapped
    }

    /**
     * @param value Unique name for the cluster that you want to create.
     */
    @JvmName("vrpbppedefhwibom")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Version of FinSpace Managed kdb to run.
     */
    @JvmName("qjmnliqlpplqlbcs")
    public suspend fun releaseLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseLabel = mapped
    }

    /**
     * @param value Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     */
    @JvmName("dubjvckpnvmgcfme")
    public suspend
    fun savedownStorageConfiguration(`value`: KxClusterSavedownStorageConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.savedownStorageConfiguration = mapped
    }

    /**
     * @param argument Size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose `type` as RDB. All the data written to this storage space is lost when the cluster node is restarted. See savedown_storage_configuration.
     */
    @JvmName("barxukcsnuwoifon")
    public suspend
    fun savedownStorageConfiguration(argument: suspend KxClusterSavedownStorageConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxClusterSavedownStorageConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.savedownStorageConfiguration = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mpldeuwnlsbbynsd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("juuljiwrsbldpukg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     */
    @JvmName("qpwaonpouvsghicd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * The following arguments are optional:
     */
    @JvmName("rnsoigfqpuabdeio")
    public suspend fun vpcConfiguration(`value`: KxClusterVpcConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfiguration = mapped
    }

    /**
     * @param argument Configuration details about the network where the Privatelink endpoint of the cluster resides. See vpc_configuration.
     * The following arguments are optional:
     */
    @JvmName("gimfdvytxwajhark")
    public suspend
    fun vpcConfiguration(argument: suspend KxClusterVpcConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxClusterVpcConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfiguration = mapped
    }

    internal fun build(): KxClusterArgs = KxClusterArgs(
        autoScalingConfiguration = autoScalingConfiguration,
        availabilityZoneId = availabilityZoneId,
        azMode = azMode,
        cacheStorageConfigurations = cacheStorageConfigurations,
        capacityConfiguration = capacityConfiguration,
        code = code,
        commandLineArguments = commandLineArguments,
        databases = databases,
        description = description,
        environmentId = environmentId,
        executionRole = executionRole,
        initializationScript = initializationScript,
        name = name,
        releaseLabel = releaseLabel,
        savedownStorageConfiguration = savedownStorageConfiguration,
        tags = tags,
        type = type,
        vpcConfiguration = vpcConfiguration,
    )
}
