@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentCustomDnsConfiguration
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentCustomDnsConfiguration.Companion.toKotlin as kxEnvironmentCustomDnsConfigurationToKotlin
import com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfiguration.Companion.toKotlin as kxEnvironmentTransitGatewayConfigurationToKotlin

/**
 * Builder for [KxEnvironment].
 */
@PulumiTagMarker
public class KxEnvironmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KxEnvironmentArgs = KxEnvironmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KxEnvironmentArgsBuilder.() -> Unit) {
        val builder = KxEnvironmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KxEnvironment {
        val builtJavaResource = com.pulumi.aws.finspace.KxEnvironment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KxEnvironment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FinSpace Kx Environment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .kmsKeyId(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### With Transit Gateway Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleEnv = new KxEnvironment("exampleEnv", KxEnvironmentArgs.builder()
 *             .description("Environment description")
 *             .kmsKeyId(exampleKey.arn())
 *             .transitGatewayConfiguration(KxEnvironmentTransitGatewayConfigurationArgs.builder()
 *                 .transitGatewayId(exampleTransitGateway.id())
 *                 .routableCidrSpace("100.64.0.0/26")
 *                 .build())
 *             .customDnsConfigurations(KxEnvironmentCustomDnsConfigurationArgs.builder()
 *                 .customDnsServerName("example.finspace.amazonaws.com")
 *                 .customDnsServerIp("10.0.0.76")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Transit Gateway Attachment Network ACL Configuration
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
 * ```
 *
 */
public class KxEnvironment internal constructor(
    override val javaResource: com.pulumi.aws.finspace.KxEnvironment,
) : KotlinCustomResource(javaResource, KxEnvironmentMapper) {
    /**
     * Amazon Resource Name (ARN) identifier of the KX environment.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS Availability Zone IDs that this environment is available in. Important when selecting VPC subnets to use in cluster creation.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Timestamp at which the environment is created in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    public val customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfiguration>>?
        get() = javaResource.customDnsConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        kxEnvironmentCustomDnsConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Description for the KX environment.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Unique identifier for the AWS environment infrastructure account.
     */
    public val infrastructureAccountId: Output<String>
        get() = javaResource.infrastructureAccountId().applyValue({ args0 -> args0 })

    /**
     * KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Last timestamp at which the environment was updated in FinSpace. Value determined as epoch time in seconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000.
     */
    public val lastModifiedTimestamp: Output<String>
        get() = javaResource.lastModifiedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Name of the KX environment that you want to create.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Status of environment creation
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    public val transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfiguration>?
        get() = javaResource.transitGatewayConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kxEnvironmentTransitGatewayConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object KxEnvironmentMapper : ResourceMapper<KxEnvironment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.finspace.KxEnvironment::class == javaResource::class

    override fun map(javaResource: Resource): KxEnvironment = KxEnvironment(
        javaResource as
            com.pulumi.aws.finspace.KxEnvironment,
    )
}

/**
 * @see [KxEnvironment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KxEnvironment].
 */
public suspend fun kxEnvironment(
    name: String,
    block: suspend KxEnvironmentResourceBuilder.() -> Unit,
): KxEnvironment {
    val builder = KxEnvironmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KxEnvironment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kxEnvironment(name: String): KxEnvironment {
    val builder = KxEnvironmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
