@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxEnvironmentArgs.builder
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentCustomDnsConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentCustomDnsConfigurationArgsBuilder
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentTransitGatewayConfigurationArgs
import com.pulumi.aws.finspace.kotlin.inputs.KxEnvironmentTransitGatewayConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx Environment.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .kmsKeyId(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ### With Transit Gateway Configuration
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.ec2transitgateway.TransitGateway;
 * import com.pulumi.aws.ec2transitgateway.TransitGatewayArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationArgs;
 * import com.pulumi.aws.finspace.inputs.KxEnvironmentCustomDnsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Sample KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleTransitGateway = new TransitGateway("exampleTransitGateway", TransitGatewayArgs.builder()
 *             .description("example")
 *             .build());
 *         var exampleEnv = new KxEnvironment("exampleEnv", KxEnvironmentArgs.builder()
 *             .description("Environment description")
 *             .kmsKeyId(exampleKey.arn())
 *             .transitGatewayConfiguration(KxEnvironmentTransitGatewayConfigurationArgs.builder()
 *                 .transitGatewayId(exampleTransitGateway.id())
 *                 .routableCidrSpace("100.64.0.0/26")
 *                 .build())
 *             .customDnsConfigurations(KxEnvironmentCustomDnsConfigurationArgs.builder()
 *                 .customDnsServerName("example.finspace.amazonaws.com")
 *                 .customDnsServerIp("10.0.0.76")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### With Transit Gateway Attachment Network ACL Configuration
 * No Java example available.
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx Environment using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:finspace/kxEnvironment:KxEnvironment example n3ceo7wqxoxcti5tujqwzs
 * ```
 * @property customDnsConfigurations List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
 * @property description Description for the KX environment.
 * @property kmsKeyId KMS key ID to encrypt your data in the FinSpace environment.
 * The following arguments are optional:
 * @property name Name of the KX environment that you want to create.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property transitGatewayConfiguration Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
 */
public data class KxEnvironmentArgs(
    public val customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfigurationArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxEnvironmentArgs =
        com.pulumi.aws.finspace.KxEnvironmentArgs.builder()
            .customDnsConfigurations(
                customDnsConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitGatewayConfiguration(
                transitGatewayConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [KxEnvironmentArgs].
 */
@PulumiTagMarker
public class KxEnvironmentArgsBuilder internal constructor() {
    private var customDnsConfigurations: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitGatewayConfiguration: Output<KxEnvironmentTransitGatewayConfigurationArgs>? =
        null

    /**
     * @param value List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("bakhbrhstgikfoej")
    public suspend
    fun customDnsConfigurations(`value`: Output<List<KxEnvironmentCustomDnsConfigurationArgs>>) {
        this.customDnsConfigurations = value
    }

    @JvmName("ltjcjofuvshyaehm")
    public suspend fun customDnsConfigurations(
        vararg
        values: Output<KxEnvironmentCustomDnsConfigurationArgs>,
    ) {
        this.customDnsConfigurations = Output.all(values.asList())
    }

    /**
     * @param values List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("tmkhvumuokwalxnw")
    public suspend
    fun customDnsConfigurations(values: List<Output<KxEnvironmentCustomDnsConfigurationArgs>>) {
        this.customDnsConfigurations = Output.all(values)
    }

    /**
     * @param value Description for the KX environment.
     */
    @JvmName("dywpwtalgkudpnlq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    @JvmName("avoocjuwyenfpeub")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the KX environment that you want to create.
     */
    @JvmName("enhicajdvxpfwrwp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qcupuuyaiwhgyruc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("qoubpvylglaqnluv")
    public suspend
    fun transitGatewayConfiguration(`value`: Output<KxEnvironmentTransitGatewayConfigurationArgs>) {
        this.transitGatewayConfiguration = value
    }

    /**
     * @param value List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("byteeskwlovptvhw")
    public suspend
    fun customDnsConfigurations(`value`: List<KxEnvironmentCustomDnsConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("ooehnrnrxjwuqxba")
    public suspend
    fun customDnsConfigurations(argument: List<suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("omequkgsskmujfru")
    public suspend fun customDnsConfigurations(
        vararg
        argument: suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param argument List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("yduwylohcdajgcye")
    public suspend
    fun customDnsConfigurations(argument: suspend KxEnvironmentCustomDnsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxEnvironmentCustomDnsConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customDnsConfigurations = mapped
    }

    /**
     * @param values List of DNS server name and server IP. This is used to set up Route-53 outbound resolvers. Defined below.
     */
    @JvmName("bgbibpybflmwmdhc")
    public suspend fun customDnsConfigurations(
        vararg
        values: KxEnvironmentCustomDnsConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDnsConfigurations = mapped
    }

    /**
     * @param value Description for the KX environment.
     */
    @JvmName("uwrheeaupkethmco")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS key ID to encrypt your data in the FinSpace environment.
     * The following arguments are optional:
     */
    @JvmName("ihjjwnsrpddxhvel")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the KX environment that you want to create.
     */
    @JvmName("hyevuwdeexucpxky")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mnyscioisfxhnxec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ltscjictwtdqnuhq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("ftgxigebgekrvsgo")
    public suspend
    fun transitGatewayConfiguration(`value`: KxEnvironmentTransitGatewayConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitGatewayConfiguration = mapped
    }

    /**
     * @param argument Transit gateway and network configuration that is used to connect the KX environment to an internal network. Defined below.
     */
    @JvmName("sgvnffniodiguqoc")
    public suspend
    fun transitGatewayConfiguration(argument: suspend KxEnvironmentTransitGatewayConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = KxEnvironmentTransitGatewayConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.transitGatewayConfiguration = mapped
    }

    internal fun build(): KxEnvironmentArgs = KxEnvironmentArgs(
        customDnsConfigurations = customDnsConfigurations,
        description = description,
        kmsKeyId = kmsKeyId,
        name = name,
        tags = tags,
        transitGatewayConfiguration = transitGatewayConfiguration,
    )
}
