@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin

import com.pulumi.aws.finspace.KxUserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FinSpace Kx User.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.finspace.KxEnvironment;
 * import com.pulumi.aws.finspace.KxEnvironmentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.finspace.KxUser;
 * import com.pulumi.aws.finspace.KxUserArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Example KMS Key")
 *             .deletionWindowInDays(7)
 *             .build());
 *         var exampleKxEnvironment = new KxEnvironment("exampleKxEnvironment", KxEnvironmentArgs.builder()
 *             .kmsKeyId(exampleKey.arn())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "ec2.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         var exampleKxUser = new KxUser("exampleKxUser", KxUserArgs.builder()
 *             .environmentId(exampleKxEnvironment.id())
 *             .iamRole(exampleRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import an AWS FinSpace Kx User using the `id` (environment ID and user name, comma-delimited). For example:
 * ```sh
 *  $ pulumi import aws:finspace/kxUser:KxUser example n3ceo7wqxoxcti5tujqwzs,my-tf-kx-user
 * ```
 * @property environmentId Unique identifier for the KX environment.
 * @property iamRole IAM role ARN to be associated with the user.
 * The following arguments are optional:
 * @property name A unique identifier for the user.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class KxUserArgs(
    public val environmentId: Output<String>? = null,
    public val iamRole: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.KxUserArgs> {
    override fun toJava(): com.pulumi.aws.finspace.KxUserArgs =
        com.pulumi.aws.finspace.KxUserArgs.builder()
            .environmentId(environmentId?.applyValue({ args0 -> args0 }))
            .iamRole(iamRole?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KxUserArgs].
 */
@PulumiTagMarker
public class KxUserArgsBuilder internal constructor() {
    private var environmentId: Output<String>? = null

    private var iamRole: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("exrmtdneyykgfqsg")
    public suspend fun environmentId(`value`: Output<String>) {
        this.environmentId = value
    }

    /**
     * @param value IAM role ARN to be associated with the user.
     * The following arguments are optional:
     */
    @JvmName("nsgjndjdxssvqitr")
    public suspend fun iamRole(`value`: Output<String>) {
        this.iamRole = value
    }

    /**
     * @param value A unique identifier for the user.
     */
    @JvmName("hypdlrpehvvmdgxg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ivriqsgvitgjlwqa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique identifier for the KX environment.
     */
    @JvmName("lsimdttmlkedwnyx")
    public suspend fun environmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentId = mapped
    }

    /**
     * @param value IAM role ARN to be associated with the user.
     * The following arguments are optional:
     */
    @JvmName("rocrwviatmsewvsi")
    public suspend fun iamRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRole = mapped
    }

    /**
     * @param value A unique identifier for the user.
     */
    @JvmName("agvlnythrwbpecdv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uhwidgmtgvhrvoxi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xtnitdoferrwloxe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KxUserArgs = KxUserArgs(
        environmentId = environmentId,
        iamRole = iamRole,
        name = name,
        tags = tags,
    )
}
