@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size Size of cache in Gigabytes.
 * Please note that create/update timeouts may have to be adjusted from the default 4 hours depending upon the
 * volume of data being cached, as noted in the example configuration.
 * @property type Type of KDB database. The following types are available:
 * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
 * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
 * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
 */
public data class KxClusterCacheStorageConfigurationArgs(
    public val size: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterCacheStorageConfigurationArgs.builder()
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterCacheStorageConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterCacheStorageConfigurationArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Size of cache in Gigabytes.
     * Please note that create/update timeouts may have to be adjusted from the default 4 hours depending upon the
     * volume of data being cached, as noted in the example configuration.
     */
    @JvmName("egrqbfvotmmscnbl")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     */
    @JvmName("qsvggjtaslbbdppe")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Size of cache in Gigabytes.
     * Please note that create/update timeouts may have to be adjusted from the default 4 hours depending upon the
     * volume of data being cached, as noted in the example configuration.
     */
    @JvmName("nfoxfpvigvwjunyp")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Type of KDB database. The following types are available:
     * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
     * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
     * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
     */
    @JvmName("rgelhtlxrppygyke")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): KxClusterCacheStorageConfigurationArgs =
        KxClusterCacheStorageConfigurationArgs(
            size = size ?: throw PulumiNullFieldException("size"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
