@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterCodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Bucket Unique name for the S3 bucket.
 * @property s3Key Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
 * @property s3ObjectVersion Version of an S3 Object.
 */
public data class KxClusterCodeArgs(
    public val s3Bucket: Output<String>,
    public val s3Key: Output<String>,
    public val s3ObjectVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterCodeArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterCodeArgs =
        com.pulumi.aws.finspace.inputs.KxClusterCodeArgs.builder()
            .s3Bucket(s3Bucket.applyValue({ args0 -> args0 }))
            .s3Key(s3Key.applyValue({ args0 -> args0 }))
            .s3ObjectVersion(s3ObjectVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterCodeArgs].
 */
@PulumiTagMarker
public class KxClusterCodeArgsBuilder internal constructor() {
    private var s3Bucket: Output<String>? = null

    private var s3Key: Output<String>? = null

    private var s3ObjectVersion: Output<String>? = null

    /**
     * @param value Unique name for the S3 bucket.
     */
    @JvmName("tlkhmapypopfsgms")
    public suspend fun s3Bucket(`value`: Output<String>) {
        this.s3Bucket = value
    }

    /**
     * @param value Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
     */
    @JvmName("nuugsthsdkcgjqwd")
    public suspend fun s3Key(`value`: Output<String>) {
        this.s3Key = value
    }

    /**
     * @param value Version of an S3 Object.
     */
    @JvmName("epptntwvbykkhhvc")
    public suspend fun s3ObjectVersion(`value`: Output<String>) {
        this.s3ObjectVersion = value
    }

    /**
     * @param value Unique name for the S3 bucket.
     */
    @JvmName("llevalahwxgusypr")
    public suspend fun s3Bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Bucket = mapped
    }

    /**
     * @param value Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
     */
    @JvmName("pxxfldwbaswbhqxm")
    public suspend fun s3Key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Key = mapped
    }

    /**
     * @param value Version of an S3 Object.
     */
    @JvmName("igklrwyvpcowidud")
    public suspend fun s3ObjectVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3ObjectVersion = mapped
    }

    internal fun build(): KxClusterCodeArgs = KxClusterCodeArgs(
        s3Bucket = s3Bucket ?: throw PulumiNullFieldException("s3Bucket"),
        s3Key = s3Key ?: throw PulumiNullFieldException("s3Key"),
        s3ObjectVersion = s3ObjectVersion,
    )
}
