@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cacheConfigurations Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
 * @property changesetId A unique identifier of the changeset that is associated with the cluster.
 * @property databaseName Name of the KX database.
 */
public data class KxClusterDatabaseArgs(
    public val cacheConfigurations: Output<List<KxClusterDatabaseCacheConfigurationArgs>>? = null,
    public val changesetId: Output<String>? = null,
    public val databaseName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs =
        com.pulumi.aws.finspace.inputs.KxClusterDatabaseArgs.builder()
            .cacheConfigurations(
                cacheConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .changesetId(changesetId?.applyValue({ args0 -> args0 }))
            .databaseName(databaseName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterDatabaseArgs].
 */
@PulumiTagMarker
public class KxClusterDatabaseArgsBuilder internal constructor() {
    private var cacheConfigurations: Output<List<KxClusterDatabaseCacheConfigurationArgs>>? = null

    private var changesetId: Output<String>? = null

    private var databaseName: Output<String>? = null

    /**
     * @param value Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("baayhasjticejpjy")
    public suspend
    fun cacheConfigurations(`value`: Output<List<KxClusterDatabaseCacheConfigurationArgs>>) {
        this.cacheConfigurations = value
    }

    @JvmName("ndwioyqaoghlehof")
    public suspend fun cacheConfigurations(
        vararg
        values: Output<KxClusterDatabaseCacheConfigurationArgs>,
    ) {
        this.cacheConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("lhgtdmboxvegwabv")
    public suspend
    fun cacheConfigurations(values: List<Output<KxClusterDatabaseCacheConfigurationArgs>>) {
        this.cacheConfigurations = Output.all(values)
    }

    /**
     * @param value A unique identifier of the changeset that is associated with the cluster.
     */
    @JvmName("pvdvajvkmnxeaieb")
    public suspend fun changesetId(`value`: Output<String>) {
        this.changesetId = value
    }

    /**
     * @param value Name of the KX database.
     */
    @JvmName("ehlhyjvlencvsjyo")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("ffenmspswhrxbkbf")
    public suspend fun cacheConfigurations(`value`: List<KxClusterDatabaseCacheConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("yycnqmnatusfblyv")
    public suspend
    fun cacheConfigurations(argument: List<suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("feqbhukuoltomtib")
    public suspend fun cacheConfigurations(
        vararg
        argument: suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param argument Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("jlohcwcypajssedb")
    public suspend
    fun cacheConfigurations(argument: suspend KxClusterDatabaseCacheConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            KxClusterDatabaseCacheConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.cacheConfigurations = mapped
    }

    /**
     * @param values Configuration details for the disk cache to increase performance reading from a KX database mounted to the cluster. See cache_configurations.
     */
    @JvmName("cdtaevrkpbvwaalc")
    public suspend fun cacheConfigurations(vararg values: KxClusterDatabaseCacheConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheConfigurations = mapped
    }

    /**
     * @param value A unique identifier of the changeset that is associated with the cluster.
     */
    @JvmName("qgmjerhupkqqlclv")
    public suspend fun changesetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changesetId = mapped
    }

    /**
     * @param value Name of the KX database.
     */
    @JvmName("pgoviymmsedaraqi")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    internal fun build(): KxClusterDatabaseArgs = KxClusterDatabaseArgs(
        cacheConfigurations = cacheConfigurations,
        changesetId = changesetId,
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
    )
}
