@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterSavedownStorageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property size Size of temporary storage in gigabytes. Must be between 10 and 16000.
 * @property type Type of writeable storage space for temporarily storing your savedown data. The valid values are:
 * * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
 */
public data class KxClusterSavedownStorageConfigurationArgs(
    public val size: Output<Int>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterSavedownStorageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterSavedownStorageConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterSavedownStorageConfigurationArgs.builder()
            .size(size.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterSavedownStorageConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterSavedownStorageConfigurationArgsBuilder internal constructor() {
    private var size: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value Size of temporary storage in gigabytes. Must be between 10 and 16000.
     */
    @JvmName("lmdhuncpmfwbvmic")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Type of writeable storage space for temporarily storing your savedown data. The valid values are:
     * * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
     */
    @JvmName("nkbxhwlgcbxhlqol")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Size of temporary storage in gigabytes. Must be between 10 and 16000.
     */
    @JvmName("ldftysxicgmhcpxk")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Type of writeable storage space for temporarily storing your savedown data. The valid values are:
     * * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
     */
    @JvmName("imjwbvccfwrjsgmi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): KxClusterSavedownStorageConfigurationArgs =
        KxClusterSavedownStorageConfigurationArgs(
            size = size ?: throw PulumiNullFieldException("size"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
