@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ipAddressType IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
 * @property securityGroupIds Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
 * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
 * @property subnetIds
 * @property vpcId Identifier of the VPC endpoint
 */
public data class KxClusterVpcConfigurationArgs(
    public val ipAddressType: Output<String>,
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxClusterVpcConfigurationArgs.builder()
            .ipAddressType(ipAddressType.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxClusterVpcConfigurationArgs].
 */
@PulumiTagMarker
public class KxClusterVpcConfigurationArgsBuilder internal constructor() {
    private var ipAddressType: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
     */
    @JvmName("exyprjgofpjufsyb")
    public suspend fun ipAddressType(`value`: Output<String>) {
        this.ipAddressType = value
    }

    /**
     * @param value Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
     * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
     */
    @JvmName("lrcflvxihnbwwens")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("xcrawsobbfqmuxwf")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
     * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
     */
    @JvmName("smakeaeccjtslnjd")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("wfvjswekjtljngci")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("yhlkluiupuqafnax")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("leelqgqvjqmbbtbs")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Identifier of the VPC endpoint
     */
    @JvmName("dnadmvuragqkuoin")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
     */
    @JvmName("iynqjykscgtjkugg")
    public suspend fun ipAddressType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAddressType = mapped
    }

    /**
     * @param value Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
     * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
     */
    @JvmName("wgsvdecbuyijbufg")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
     * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
     */
    @JvmName("dkrndvnoysihqvya")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("jvwibkijtusayuxr")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("dppvovfpyniblofv")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Identifier of the VPC endpoint
     */
    @JvmName("stsnwhphvjhwtvjd")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): KxClusterVpcConfigurationArgs = KxClusterVpcConfigurationArgs(
        ipAddressType = ipAddressType ?: throw PulumiNullFieldException("ipAddressType"),
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
