@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cidrBlock The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
 * @property icmpTypeCode Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
 * @property portRange Range of ports the rule applies to. Defined below.
 * @property protocol Protocol number. A value of `1` means all the protocols.
 * @property ruleAction Indicates whether to `allow` or `deny` the traffic that matches the rule.
 * @property ruleNumber Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
 */
public data class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs(
    public val cidrBlock: Output<String>,
    public val icmpTypeCode:
    Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs>? =
        null,
    public val portRange:
    Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs>? =
        null,
    public val protocol: Output<String>,
    public val ruleAction: Output<String>,
    public val ruleNumber: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs =
        com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs.builder()
            .cidrBlock(cidrBlock.applyValue({ args0 -> args0 }))
            .icmpTypeCode(icmpTypeCode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .portRange(portRange?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(protocol.applyValue({ args0 -> args0 }))
            .ruleAction(ruleAction.applyValue({ args0 -> args0 }))
            .ruleNumber(ruleNumber.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs].
 */
@PulumiTagMarker
public class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgsBuilder
internal constructor() {
    private var cidrBlock: Output<String>? = null

    private var icmpTypeCode:
        Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs>? =
        null

    private var portRange:
        Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs>? =
        null

    private var protocol: Output<String>? = null

    private var ruleAction: Output<String>? = null

    private var ruleNumber: Output<Int>? = null

    /**
     * @param value The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
     */
    @JvmName("iuwxqqrurrgmsymi")
    public suspend fun cidrBlock(`value`: Output<String>) {
        this.cidrBlock = value
    }

    /**
     * @param value Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
     */
    @JvmName("pbfvwabmvstfagap")
    public suspend
    fun icmpTypeCode(`value`: Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs>) {
        this.icmpTypeCode = value
    }

    /**
     * @param value Range of ports the rule applies to. Defined below.
     */
    @JvmName("bflvbkmkkknpqipv")
    public suspend
    fun portRange(`value`: Output<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs>) {
        this.portRange = value
    }

    /**
     * @param value Protocol number. A value of `1` means all the protocols.
     */
    @JvmName("erhlbmnxcjsnlnik")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Indicates whether to `allow` or `deny` the traffic that matches the rule.
     */
    @JvmName("wkijluxqxrndincf")
    public suspend fun ruleAction(`value`: Output<String>) {
        this.ruleAction = value
    }

    /**
     * @param value Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
     */
    @JvmName("igfdpafytqqfwlpx")
    public suspend fun ruleNumber(`value`: Output<Int>) {
        this.ruleNumber = value
    }

    /**
     * @param value The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
     */
    @JvmName("xoxmwqnopdobnlhu")
    public suspend fun cidrBlock(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidrBlock = mapped
    }

    /**
     * @param value Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
     */
    @JvmName("ruvklfadelaauijn")
    public suspend
    fun icmpTypeCode(`value`: KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.icmpTypeCode = mapped
    }

    /**
     * @param argument Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
     */
    @JvmName("lyifclguubrrqrah")
    public suspend
    fun icmpTypeCode(argument: suspend KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsBuilder.() -> Unit) {
        val toBeMapped =
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.icmpTypeCode = mapped
    }

    /**
     * @param value Range of ports the rule applies to. Defined below.
     */
    @JvmName("xaeylvloahwjdtat")
    public suspend
    fun portRange(`value`: KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portRange = mapped
    }

    /**
     * @param argument Range of ports the rule applies to. Defined below.
     */
    @JvmName("xmtkdlveglvybkxs")
    public suspend
    fun portRange(argument: suspend KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsBuilder.() -> Unit) {
        val toBeMapped =
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRangeArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.portRange = mapped
    }

    /**
     * @param value Protocol number. A value of `1` means all the protocols.
     */
    @JvmName("ulewxghlafwkskqx")
    public suspend fun protocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Indicates whether to `allow` or `deny` the traffic that matches the rule.
     */
    @JvmName("iobeqigxfubusnic")
    public suspend fun ruleAction(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleAction = mapped
    }

    /**
     * @param value Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
     */
    @JvmName("ycgydttpaceirsec")
    public suspend fun ruleNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleNumber = mapped
    }

    internal fun build():
        KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs =
        KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationArgs(
            cidrBlock = cidrBlock ?: throw PulumiNullFieldException("cidrBlock"),
            icmpTypeCode = icmpTypeCode,
            portRange = portRange,
            protocol = protocol ?: throw PulumiNullFieldException("protocol"),
            ruleAction = ruleAction ?: throw PulumiNullFieldException("ruleAction"),
            ruleNumber = ruleNumber ?: throw PulumiNullFieldException("ruleNumber"),
        )
}
