@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.inputs

import com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property code ICMP code. A value of `-1` means all codes for the specified ICMP type.
 * @property type ICMP type. A value of `-1` means all types.
 */
public data class
KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs(
    public val code: Output<Int>,
    public val type: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs> {
    override fun toJava():
        com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs =
        com.pulumi.aws.finspace.inputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs.builder()
            .code(code.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs].
 */
@PulumiTagMarker
public class
KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgsBuilder
internal constructor() {
    private var code: Output<Int>? = null

    private var type: Output<Int>? = null

    /**
     * @param value ICMP code. A value of `-1` means all codes for the specified ICMP type.
     */
    @JvmName("jsvwtjytcymssvbt")
    public suspend fun code(`value`: Output<Int>) {
        this.code = value
    }

    /**
     * @param value ICMP type. A value of `-1` means all types.
     */
    @JvmName("umeiugbuuqybhnja")
    public suspend fun type(`value`: Output<Int>) {
        this.type = value
    }

    /**
     * @param value ICMP code. A value of `-1` means all codes for the specified ICMP type.
     */
    @JvmName("cuonvmelrlhyvlla")
    public suspend fun code(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value ICMP type. A value of `-1` means all types.
     */
    @JvmName("gnndqympogcvyvrn")
    public suspend fun type(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build():
        KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs =
        KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCodeArgs(
            code = code ?: throw PulumiNullFieldException("code"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
