@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property size Size of cache in Gigabytes.
 * Please note that create/update timeouts may have to be adjusted from the default 4 hours depending upon the
 * volume of data being cached, as noted in the example configuration.
 * @property type Type of KDB database. The following types are available:
 * * HDB - Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed KX databases mounted to the cluster.
 * * RDB - Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the `savedownStorageConfiguration` parameter.
 * * GATEWAY - A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a  writable local storage.
 */
public data class KxClusterCacheStorageConfiguration(
    public val size: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterCacheStorageConfiguration):
            KxClusterCacheStorageConfiguration = KxClusterCacheStorageConfiguration(
            size = javaType.size(),
            type = javaType.type(),
        )
    }
}
