@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property s3Bucket Unique name for the S3 bucket.
 * @property s3Key Full S3 path (excluding bucket) to the .zip file that contains the code to be loaded onto the cluster when it’s started.
 * @property s3ObjectVersion Version of an S3 Object.
 */
public data class KxClusterCode(
    public val s3Bucket: String,
    public val s3Key: String,
    public val s3ObjectVersion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterCode): KxClusterCode =
            KxClusterCode(
                s3Bucket = javaType.s3Bucket(),
                s3Key = javaType.s3Key(),
                s3ObjectVersion = javaType.s3ObjectVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
