@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property size Size of temporary storage in gigabytes. Must be between 10 and 16000.
 * @property type Type of writeable storage space for temporarily storing your savedown data. The valid values are:
 * * SDS01 - This type represents 3000 IOPS and io2 ebs volume type.
 */
public data class KxClusterSavedownStorageConfiguration(
    public val size: Int,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterSavedownStorageConfiguration):
            KxClusterSavedownStorageConfiguration = KxClusterSavedownStorageConfiguration(
            size = javaType.size(),
            type = javaType.type(),
        )
    }
}
