@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ipAddressType IP address type for cluster network configuration parameters. The following type is available: IP_V4 - IP address version 4.
 * @property securityGroupIds Unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.
 * * `subnet_ids `- (Required) Identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.
 * @property subnetIds
 * @property vpcId Identifier of the VPC endpoint
 */
public data class KxClusterVpcConfiguration(
    public val ipAddressType: String,
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxClusterVpcConfiguration):
            KxClusterVpcConfiguration = KxClusterVpcConfiguration(
            ipAddressType = javaType.ipAddressType(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
