@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property attachmentNetworkAclConfigurations Rules that define how you manage outbound traffic from kdb network to your internal network. Defined below.
 * @property routableCidrSpace Routing CIDR on behalf of KX environment. It could be any “/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer’s transit gateway routing table so that the traffics could be routed to KX network.
 * @property transitGatewayId Identifier of the transit gateway created by the customer to connect outbound traffics from KX network to your internal network.
 */
public data class KxEnvironmentTransitGatewayConfiguration(
    public val attachmentNetworkAclConfigurations:
    List<KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration>? = null,
    public val routableCidrSpace: String,
    public val transitGatewayId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxEnvironmentTransitGatewayConfiguration):
            KxEnvironmentTransitGatewayConfiguration = KxEnvironmentTransitGatewayConfiguration(
            attachmentNetworkAclConfigurations = javaType.attachmentNetworkAclConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration.Companion.toKotlin(args0)
                })
            }),
            routableCidrSpace = javaType.routableCidrSpace(),
            transitGatewayId = javaType.transitGatewayId(),
        )
    }
}
