@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.finspace.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The IPv4 network range to allow or deny, in CIDR notation. The specified CIDR block is modified to its canonical form. For example, `100.68.0.18/18` will be converted to `100.68.0.0/18`.
 * @property icmpTypeCode Defines the ICMP protocol that consists of the ICMP type and code. Defined below.
 * @property portRange Range of ports the rule applies to. Defined below.
 * @property protocol Protocol number. A value of `1` means all the protocols.
 * @property ruleAction Indicates whether to `allow` or `deny` the traffic that matches the rule.
 * @property ruleNumber Rule number for the entry. All the network ACL entries are processed in ascending order by rule number.
 */
public data class KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration(
    public val cidrBlock: String,
    public val icmpTypeCode:
    KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCode? = null,
    public val portRange:
    KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRange? = null,
    public val protocol: String,
    public val ruleAction: String,
    public val ruleNumber: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.finspace.outputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration):
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration =
            KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfiguration(
                cidrBlock = javaType.cidrBlock(),
                icmpTypeCode = javaType.icmpTypeCode().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationIcmpTypeCode.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                portRange = javaType.portRange().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.finspace.kotlin.outputs.KxEnvironmentTransitGatewayConfigurationAttachmentNetworkAclConfigurationPortRange.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                protocol = javaType.protocol(),
                ruleAction = javaType.ruleAction(),
                ruleNumber = javaType.ruleNumber(),
            )
    }
}
