@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin

import com.pulumi.aws.fis.ExperimentTemplateArgs.builder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateActionArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateActionArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateLogConfigurationArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateLogConfigurationArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateStopConditionArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateStopConditionArgsBuilder
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateTargetArgs
import com.pulumi.aws.fis.kotlin.inputs.ExperimentTemplateTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an FIS Experiment Template, which can be used to run an experiment.
 * An experiment template contains one or more actions to run on specified targets during an experiment.
 * It also contains the stop conditions that prevent the experiment from going out of bounds.
 * See [Amazon Fault Injection Simulator](https://docs.aws.amazon.com/fis/index.html)
 * for more information.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fis.ExperimentTemplate;
 * import com.pulumi.aws.fis.ExperimentTemplateArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateActionTargetArgs;
 * import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExperimentTemplate("example", ExperimentTemplateArgs.builder()
 *             .description("example")
 *             .roleArn(aws_iam_role.example().arn())
 *             .stopConditions(ExperimentTemplateStopConditionArgs.builder()
 *                 .source("none")
 *                 .build())
 *             .actions(ExperimentTemplateActionArgs.builder()
 *                 .name("example-action")
 *                 .actionId("aws:ec2:terminate-instances")
 *                 .target(ExperimentTemplateActionTargetArgs.builder()
 *                     .key("Instances")
 *                     .value("example-target")
 *                     .build())
 *                 .build())
 *             .targets(ExperimentTemplateTargetArgs.builder()
 *                 .name("example-target")
 *                 .resourceType("aws:ec2:instance")
 *                 .selectionMode("COUNT(1)")
 *                 .resourceTags(ExperimentTemplateTargetResourceTagArgs.builder()
 *                     .key("env")
 *                     .value("example")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import FIS Experiment Templates using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:fis/experimentTemplate:ExperimentTemplate template EXT123AbCdEfGhIjK
 * ```
 * @property actions Action to be performed during an experiment. See below.
 * @property description Description for the experiment template.
 * @property logConfiguration The configuration for experiment logging. See below.
 * @property roleArn ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
 * @property stopConditions When an ongoing experiment should be stopped. See below.
 * The following arguments are optional:
 * @property tags Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targets Target of an action. See below.
 */
public data class ExperimentTemplateArgs(
    public val actions: Output<List<ExperimentTemplateActionArgs>>? = null,
    public val description: Output<String>? = null,
    public val logConfiguration: Output<ExperimentTemplateLogConfigurationArgs>? = null,
    public val roleArn: Output<String>? = null,
    public val stopConditions: Output<List<ExperimentTemplateStopConditionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targets: Output<List<ExperimentTemplateTargetArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.ExperimentTemplateArgs> {
    override fun toJava(): com.pulumi.aws.fis.ExperimentTemplateArgs =
        com.pulumi.aws.fis.ExperimentTemplateArgs.builder()
            .actions(
                actions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .logConfiguration(logConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .stopConditions(
                stopConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targets(
                targets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExperimentTemplateArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateArgsBuilder internal constructor() {
    private var actions: Output<List<ExperimentTemplateActionArgs>>? = null

    private var description: Output<String>? = null

    private var logConfiguration: Output<ExperimentTemplateLogConfigurationArgs>? = null

    private var roleArn: Output<String>? = null

    private var stopConditions: Output<List<ExperimentTemplateStopConditionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targets: Output<List<ExperimentTemplateTargetArgs>>? = null

    /**
     * @param value Action to be performed during an experiment. See below.
     */
    @JvmName("imdotjeuykpamyno")
    public suspend fun actions(`value`: Output<List<ExperimentTemplateActionArgs>>) {
        this.actions = value
    }

    @JvmName("qelmlhporkovfiri")
    public suspend fun actions(vararg values: Output<ExperimentTemplateActionArgs>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Action to be performed during an experiment. See below.
     */
    @JvmName("pmatqbrpqtspadcq")
    public suspend fun actions(values: List<Output<ExperimentTemplateActionArgs>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Description for the experiment template.
     */
    @JvmName("anatrhdibpyekylg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The configuration for experiment logging. See below.
     */
    @JvmName("ulesorgugldjefes")
    public suspend fun logConfiguration(`value`: Output<ExperimentTemplateLogConfigurationArgs>) {
        this.logConfiguration = value
    }

    /**
     * @param value ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @JvmName("rtsphtvdbafaowas")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("syopidpcfxocmjsa")
    public suspend fun stopConditions(`value`: Output<List<ExperimentTemplateStopConditionArgs>>) {
        this.stopConditions = value
    }

    @JvmName("rlaawrbtauppuuhr")
    public suspend fun stopConditions(vararg values: Output<ExperimentTemplateStopConditionArgs>) {
        this.stopConditions = Output.all(values.asList())
    }

    /**
     * @param values When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("podipfgqfqwajprm")
    public suspend fun stopConditions(values: List<Output<ExperimentTemplateStopConditionArgs>>) {
        this.stopConditions = Output.all(values)
    }

    /**
     * @param value Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("srmreyenhwmurydq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Target of an action. See below.
     */
    @JvmName("qluqwmrnpvifubgd")
    public suspend fun targets(`value`: Output<List<ExperimentTemplateTargetArgs>>) {
        this.targets = value
    }

    @JvmName("blglxqkvvnpynpla")
    public suspend fun targets(vararg values: Output<ExperimentTemplateTargetArgs>) {
        this.targets = Output.all(values.asList())
    }

    /**
     * @param values Target of an action. See below.
     */
    @JvmName("wglhllcjiybxtxgg")
    public suspend fun targets(values: List<Output<ExperimentTemplateTargetArgs>>) {
        this.targets = Output.all(values)
    }

    /**
     * @param value Action to be performed during an experiment. See below.
     */
    @JvmName("orycyurfqxkbqllj")
    public suspend fun actions(`value`: List<ExperimentTemplateActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("dlhuuhspshyjimkj")
    public suspend
    fun actions(argument: List<suspend ExperimentTemplateActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("bacfxatgxadkmplj")
    public suspend fun actions(
        vararg
        argument: suspend ExperimentTemplateActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param argument Action to be performed during an experiment. See below.
     */
    @JvmName("vqltrapdwfgyqesj")
    public suspend fun actions(argument: suspend ExperimentTemplateActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.actions = mapped
    }

    /**
     * @param values Action to be performed during an experiment. See below.
     */
    @JvmName("iaqsuewpqwmcfwek")
    public suspend fun actions(vararg values: ExperimentTemplateActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Description for the experiment template.
     */
    @JvmName("iaasqvgqldktpptt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The configuration for experiment logging. See below.
     */
    @JvmName("ttlmoksbfenupfci")
    public suspend fun logConfiguration(`value`: ExperimentTemplateLogConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfiguration = mapped
    }

    /**
     * @param argument The configuration for experiment logging. See below.
     */
    @JvmName("ytedoqlqevnrdrjq")
    public suspend
    fun logConfiguration(argument: suspend ExperimentTemplateLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentTemplateLogConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logConfiguration = mapped
    }

    /**
     * @param value ARN of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @JvmName("wdubhhxadbmqdvdi")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("ifchnatcydsgtfes")
    public suspend fun stopConditions(`value`: List<ExperimentTemplateStopConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("prgdkcxufiyrhuyh")
    public suspend
    fun stopConditions(argument: List<suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateStopConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("gncqsetygxqanfbg")
    public suspend fun stopConditions(
        vararg
        argument: suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateStopConditionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param argument When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("unyngnrqwmbnbsoq")
    public suspend
    fun stopConditions(argument: suspend ExperimentTemplateStopConditionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateStopConditionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stopConditions = mapped
    }

    /**
     * @param values When an ongoing experiment should be stopped. See below.
     * The following arguments are optional:
     */
    @JvmName("gncbobwkhyldqgow")
    public suspend fun stopConditions(vararg values: ExperimentTemplateStopConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopConditions = mapped
    }

    /**
     * @param value Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qeceaeydjacvthrr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("llkdaxtteosvallx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Target of an action. See below.
     */
    @JvmName("tpyitnikxeikcpru")
    public suspend fun targets(`value`: List<ExperimentTemplateTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("faqbqnumrkmqrmnu")
    public suspend
    fun targets(argument: List<suspend ExperimentTemplateTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("secgwwjauqjgrpld")
    public suspend fun targets(
        vararg
        argument: suspend ExperimentTemplateTargetArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param argument Target of an action. See below.
     */
    @JvmName("oqwqrkctdhstwvec")
    public suspend fun targets(argument: suspend ExperimentTemplateTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateTargetArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targets = mapped
    }

    /**
     * @param values Target of an action. See below.
     */
    @JvmName("lnklrhemmijnbnfy")
    public suspend fun targets(vararg values: ExperimentTemplateTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targets = mapped
    }

    internal fun build(): ExperimentTemplateArgs = ExperimentTemplateArgs(
        actions = actions,
        description = description,
        logConfiguration = logConfiguration,
        roleArn = roleArn,
        stopConditions = stopConditions,
        tags = tags,
        targets = targets,
    )
}
