@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actionId ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
 * @property description Description of the action.
 * @property name Friendly name of the action.
 * @property parameters Parameter(s) for the action, if applicable. See below.
 * @property startAfters Set of action names that must complete before this action can be executed.
 * @property target Action's target, if applicable. See below.
 */
public data class ExperimentTemplateActionArgs(
    public val actionId: Output<String>,
    public val description: Output<String>? = null,
    public val name: Output<String>,
    public val parameters: Output<List<ExperimentTemplateActionParameterArgs>>? = null,
    public val startAfters: Output<List<String>>? = null,
    public val target: Output<ExperimentTemplateActionTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateActionArgs.builder()
            .actionId(actionId.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .startAfters(startAfters?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExperimentTemplateActionArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateActionArgsBuilder internal constructor() {
    private var actionId: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<List<ExperimentTemplateActionParameterArgs>>? = null

    private var startAfters: Output<List<String>>? = null

    private var target: Output<ExperimentTemplateActionTargetArgs>? = null

    /**
     * @param value ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     */
    @JvmName("kjfdbcakmmiljnop")
    public suspend fun actionId(`value`: Output<String>) {
        this.actionId = value
    }

    /**
     * @param value Description of the action.
     */
    @JvmName("spvsasssikrqnuiy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Friendly name of the action.
     */
    @JvmName("xiywvyhaagqvfrgs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("xnbrxanuwxxyksqs")
    public suspend fun parameters(`value`: Output<List<ExperimentTemplateActionParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("qttgpkcjitkrxgfk")
    public suspend fun parameters(vararg values: Output<ExperimentTemplateActionParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("dwlunywefoykjupy")
    public suspend fun parameters(values: List<Output<ExperimentTemplateActionParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Set of action names that must complete before this action can be executed.
     */
    @JvmName("tacdsfxtbiqyihdr")
    public suspend fun startAfters(`value`: Output<List<String>>) {
        this.startAfters = value
    }

    @JvmName("ejwyvcwylrqpngix")
    public suspend fun startAfters(vararg values: Output<String>) {
        this.startAfters = Output.all(values.asList())
    }

    /**
     * @param values Set of action names that must complete before this action can be executed.
     */
    @JvmName("gjdlttkfmvyrfsrw")
    public suspend fun startAfters(values: List<Output<String>>) {
        this.startAfters = Output.all(values)
    }

    /**
     * @param value Action's target, if applicable. See below.
     */
    @JvmName("alpoqfanmsovnvse")
    public suspend fun target(`value`: Output<ExperimentTemplateActionTargetArgs>) {
        this.target = value
    }

    /**
     * @param value ID of the action. To find out what actions are supported see [AWS FIS actions reference](https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html).
     */
    @JvmName("htkammcxidcxuuwp")
    public suspend fun actionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionId = mapped
    }

    /**
     * @param value Description of the action.
     */
    @JvmName("xjxfioawvdfedlmv")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Friendly name of the action.
     */
    @JvmName("mbjlbrdnvphgxlnl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("vksicfvnqtylfuwn")
    public suspend fun parameters(`value`: List<ExperimentTemplateActionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("pxaqcirnkavnbjqh")
    public suspend
    fun parameters(argument: List<suspend ExperimentTemplateActionParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("nknqjcmvgrevgyii")
    public suspend fun parameters(
        vararg
        argument: suspend ExperimentTemplateActionParameterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ExperimentTemplateActionParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("pcsgwghpkyynnwpi")
    public suspend
    fun parameters(argument: suspend ExperimentTemplateActionParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExperimentTemplateActionParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameter(s) for the action, if applicable. See below.
     */
    @JvmName("madmesgqwcxocgam")
    public suspend fun parameters(vararg values: ExperimentTemplateActionParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Set of action names that must complete before this action can be executed.
     */
    @JvmName("oqfsxiyxjtqwobkc")
    public suspend fun startAfters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startAfters = mapped
    }

    /**
     * @param values Set of action names that must complete before this action can be executed.
     */
    @JvmName("cvjtkmgrrmbsdoow")
    public suspend fun startAfters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startAfters = mapped
    }

    /**
     * @param value Action's target, if applicable. See below.
     */
    @JvmName("hpdgxtgairrfymhb")
    public suspend fun target(`value`: ExperimentTemplateActionTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Action's target, if applicable. See below.
     */
    @JvmName("bstbldjggwgqvpkd")
    public suspend
    fun target(argument: suspend ExperimentTemplateActionTargetArgsBuilder.() -> Unit) {
        val toBeMapped = ExperimentTemplateActionTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): ExperimentTemplateActionArgs = ExperimentTemplateActionArgs(
        actionId = actionId ?: throw PulumiNullFieldException("actionId"),
        description = description,
        name = name ?: throw PulumiNullFieldException("name"),
        parameters = parameters,
        startAfters = startAfters,
        target = target,
    )
}
