@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroupArn The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.
 */
public data class ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs(
    public val logGroupArn: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs> {
    override fun toJava():
        com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs.builder()
            .logGroupArn(logGroupArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgsBuilder internal
constructor() {
    private var logGroupArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.
     */
    @JvmName("ickmlsqkybmrxqwu")
    public suspend fun logGroupArn(`value`: Output<String>) {
        this.logGroupArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.
     */
    @JvmName("ghytyeninyaydjur")
    public suspend fun logGroupArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logGroupArn = mapped
    }

    internal fun build(): ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs =
        ExperimentTemplateLogConfigurationCloudwatchLogsConfigurationArgs(
            logGroupArn = logGroupArn ?: throw PulumiNullFieldException("logGroupArn"),
        )
}
