@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property source Source of the condition. One of `none`, `aws:cloudwatch:alarm`.
 * @property value ARN of the CloudWatch alarm. Required if the source is a CloudWatch alarm.
 */
public data class ExperimentTemplateStopConditionArgs(
    public val source: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateStopConditionArgs.builder()
            .source(source.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentTemplateStopConditionArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateStopConditionArgsBuilder internal constructor() {
    private var source: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Source of the condition. One of `none`, `aws:cloudwatch:alarm`.
     */
    @JvmName("eooserxtawgdkhxb")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value ARN of the CloudWatch alarm. Required if the source is a CloudWatch alarm.
     */
    @JvmName("afkvqsynxvaeqqyd")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Source of the condition. One of `none`, `aws:cloudwatch:alarm`.
     */
    @JvmName("btuklosjyiomsqcc")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value ARN of the CloudWatch alarm. Required if the source is a CloudWatch alarm.
     */
    @JvmName("ummkijnolunbkvgo")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ExperimentTemplateStopConditionArgs = ExperimentTemplateStopConditionArgs(
        source = source ?: throw PulumiNullFieldException("source"),
        `value` = `value`,
    )
}
