@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.inputs

import com.pulumi.aws.fis.inputs.ExperimentTemplateTargetFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property path Attribute path for the filter.
 * @property values Set of attribute values for the filter.
 * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
 */
public data class ExperimentTemplateTargetFilterArgs(
    public val path: Output<String>,
    public val values: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.fis.inputs.ExperimentTemplateTargetFilterArgs> {
    override fun toJava(): com.pulumi.aws.fis.inputs.ExperimentTemplateTargetFilterArgs =
        com.pulumi.aws.fis.inputs.ExperimentTemplateTargetFilterArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .values(values.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ExperimentTemplateTargetFilterArgs].
 */
@PulumiTagMarker
public class ExperimentTemplateTargetFilterArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var values: Output<List<String>>? = null

    /**
     * @param value Attribute path for the filter.
     */
    @JvmName("qgwmfexbpybwmraf")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Set of attribute values for the filter.
     * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
     */
    @JvmName("ptrbwqmxlbmgyfvj")
    public suspend fun values(`value`: Output<List<String>>) {
        this.values = value
    }

    @JvmName("yojenrhrxspelejg")
    public suspend fun values(vararg values: Output<String>) {
        this.values = Output.all(values.asList())
    }

    /**
     * @param values Set of attribute values for the filter.
     * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
     */
    @JvmName("snkhxaldptytuwtx")
    public suspend fun values(values: List<Output<String>>) {
        this.values = Output.all(values)
    }

    /**
     * @param value Attribute path for the filter.
     */
    @JvmName("mmxppfaqacdggdut")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Set of attribute values for the filter.
     * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
     */
    @JvmName("bpcrixfrrhlyrkqu")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    /**
     * @param values Set of attribute values for the filter.
     * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
     */
    @JvmName("ntdtupwrbkjlefge")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.values = mapped
    }

    internal fun build(): ExperimentTemplateTargetFilterArgs = ExperimentTemplateTargetFilterArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
