@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property source Source of the condition. One of `none`, `aws:cloudwatch:alarm`.
 * @property value ARN of the CloudWatch alarm. Required if the source is a CloudWatch alarm.
 */
public data class ExperimentTemplateStopCondition(
    public val source: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateStopCondition):
            ExperimentTemplateStopCondition = ExperimentTemplateStopCondition(
            source = javaType.source(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
