@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fis.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property path Attribute path for the filter.
 * @property values Set of attribute values for the filter.
 * > **NOTE:** Values specified in a `filter` are joined with an `OR` clause, while values across multiple `filter` blocks are joined with an `AND` clause. For more information, see [Targets for AWS FIS](https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters).
 */
public data class ExperimentTemplateTargetFilter(
    public val path: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fis.outputs.ExperimentTemplateTargetFilter):
            ExperimentTemplateTargetFilter = ExperimentTemplateTargetFilter(
            path = javaType.path(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
