@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.AdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to associate/disassociate an AWS Firewall Manager administrator account. This operation must be performed in the `us-east-1` region.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fms.AdminAccount;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AdminAccount("example");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Firewall Manager administrator account association using the account ID. For example:
 * ```sh
 *  $ pulumi import aws:fms/adminAccount:AdminAccount example 123456789012
 * ```
 * @property accountId The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
 */
public data class AdminAccountArgs(
    public val accountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.AdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.fms.AdminAccountArgs =
        com.pulumi.aws.fms.AdminAccountArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdminAccountArgs].
 */
@PulumiTagMarker
public class AdminAccountArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    /**
     * @param value The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
     */
    @JvmName("owlqmrctbbkhipft")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The AWS account ID to associate with AWS Firewall Manager as the AWS Firewall Manager administrator account. This can be an AWS Organizations master account or a member account. Defaults to the current account. Must be configured to perform drift detection.
     */
    @JvmName("ttiipsjdjrfwyfgr")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    internal fun build(): AdminAccountArgs = AdminAccountArgs(
        accountId = accountId,
    )
}
