@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.PolicyArgs.builder
import com.pulumi.aws.fms.kotlin.inputs.PolicyExcludeMapArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicyExcludeMapArgsBuilder
import com.pulumi.aws.fms.kotlin.inputs.PolicyIncludeMapArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicyIncludeMapArgsBuilder
import com.pulumi.aws.fms.kotlin.inputs.PolicySecurityServicePolicyDataArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicySecurityServicePolicyDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.
 * > **NOTE:** Due to limitations with testing, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RuleGroup;
 * import com.pulumi.aws.wafregional.RuleGroupArgs;
 * import com.pulumi.aws.fms.Policy;
 * import com.pulumi.aws.fms.PolicyArgs;
 * import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .metricName("WAFRuleGroupExample")
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .excludeResourceTags(false)
 *             .remediationEnabled(false)
 *             .resourceType("AWS::ElasticLoadBalancingV2::LoadBalancer")
 *             .securityServicePolicyData(PolicySecurityServicePolicyDataArgs.builder()
 *                 .type("WAF")
 *                 .managedServiceData(exampleRuleGroup.id().applyValue(id -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("type", "WAF"),
 *                         jsonProperty("ruleGroups", jsonArray(jsonObject(
 *                             jsonProperty("id", id),
 *                             jsonProperty("overrideAction", jsonObject(
 *                                 jsonProperty("type", "COUNT")
 *                             ))
 *                         ))),
 *                         jsonProperty("defaultAction", jsonObject(
 *                             jsonProperty("type", "BLOCK")
 *                         )),
 *                         jsonProperty("overrideCustomerWebACLAssociation", false)
 *                     ))))
 *                 .build())
 *             .tags(Map.of("Name", "example-fms-policy"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Firewall Manager policies using the policy ID. For example:
 * ```sh
 *  $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
 * ```
 * @property deleteAllPolicyResources If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
 * @property deleteUnusedFmManagedResources If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
 * @property description The description of the AWS Network Firewall firewall policy.
 * @property excludeMap A map of lists of accounts and OU's to exclude from the policy.
 * @property excludeResourceTags A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
 * @property includeMap A map of lists of accounts and OU's to include in the policy.
 * @property name The friendly name of the AWS Firewall Manager Policy.
 * @property remediationEnabled A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
 * @property resourceTags A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
 * @property resourceType A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
 * @property resourceTypeLists A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
 * @property securityServicePolicyData The objects to include in Security Service Policy Data. Documented below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class PolicyArgs(
    public val deleteAllPolicyResources: Output<Boolean>? = null,
    public val deleteUnusedFmManagedResources: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val excludeMap: Output<PolicyExcludeMapArgs>? = null,
    public val excludeResourceTags: Output<Boolean>? = null,
    public val includeMap: Output<PolicyIncludeMapArgs>? = null,
    public val name: Output<String>? = null,
    public val remediationEnabled: Output<Boolean>? = null,
    public val resourceTags: Output<Map<String, String>>? = null,
    public val resourceType: Output<String>? = null,
    public val resourceTypeLists: Output<List<String>>? = null,
    public val securityServicePolicyData: Output<PolicySecurityServicePolicyDataArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.fms.PolicyArgs = com.pulumi.aws.fms.PolicyArgs.builder()
        .deleteAllPolicyResources(deleteAllPolicyResources?.applyValue({ args0 -> args0 }))
        .deleteUnusedFmManagedResources(deleteUnusedFmManagedResources?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .excludeMap(excludeMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .excludeResourceTags(excludeResourceTags?.applyValue({ args0 -> args0 }))
        .includeMap(includeMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name?.applyValue({ args0 -> args0 }))
        .remediationEnabled(remediationEnabled?.applyValue({ args0 -> args0 }))
        .resourceTags(
            resourceTags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .resourceType(resourceType?.applyValue({ args0 -> args0 }))
        .resourceTypeLists(resourceTypeLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .securityServicePolicyData(
            securityServicePolicyData?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var deleteAllPolicyResources: Output<Boolean>? = null

    private var deleteUnusedFmManagedResources: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var excludeMap: Output<PolicyExcludeMapArgs>? = null

    private var excludeResourceTags: Output<Boolean>? = null

    private var includeMap: Output<PolicyIncludeMapArgs>? = null

    private var name: Output<String>? = null

    private var remediationEnabled: Output<Boolean>? = null

    private var resourceTags: Output<Map<String, String>>? = null

    private var resourceType: Output<String>? = null

    private var resourceTypeLists: Output<List<String>>? = null

    private var securityServicePolicyData: Output<PolicySecurityServicePolicyDataArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
     */
    @JvmName("gfdebtojsxofhkly")
    public suspend fun deleteAllPolicyResources(`value`: Output<Boolean>) {
        this.deleteAllPolicyResources = value
    }

    /**
     * @param value If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
     */
    @JvmName("whnyflaolebunknp")
    public suspend fun deleteUnusedFmManagedResources(`value`: Output<Boolean>) {
        this.deleteUnusedFmManagedResources = value
    }

    /**
     * @param value The description of the AWS Network Firewall firewall policy.
     */
    @JvmName("irporoqftsjorjpv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("rbukfvsujcrosmvv")
    public suspend fun excludeMap(`value`: Output<PolicyExcludeMapArgs>) {
        this.excludeMap = value
    }

    /**
     * @param value A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
     */
    @JvmName("iyqdjprrdfuqxgwo")
    public suspend fun excludeResourceTags(`value`: Output<Boolean>) {
        this.excludeResourceTags = value
    }

    /**
     * @param value A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("kayurtigfxgrdhcf")
    public suspend fun includeMap(`value`: Output<PolicyIncludeMapArgs>) {
        this.includeMap = value
    }

    /**
     * @param value The friendly name of the AWS Firewall Manager Policy.
     */
    @JvmName("tdkexroqcydyujyl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
     */
    @JvmName("rkjajhjvgbxtqoli")
    public suspend fun remediationEnabled(`value`: Output<Boolean>) {
        this.remediationEnabled = value
    }

    /**
     * @param value A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("jnbsljvkftdkjnqd")
    public suspend fun resourceTags(`value`: Output<Map<String, String>>) {
        this.resourceTags = value
    }

    /**
     * @param value A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
     */
    @JvmName("mojgexnbtyihnoyp")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("bwppjxegqwgivtkh")
    public suspend fun resourceTypeLists(`value`: Output<List<String>>) {
        this.resourceTypeLists = value
    }

    @JvmName("wicikttaxvkorngq")
    public suspend fun resourceTypeLists(vararg values: Output<String>) {
        this.resourceTypeLists = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("xyenlscutiwlkqtw")
    public suspend fun resourceTypeLists(values: List<Output<String>>) {
        this.resourceTypeLists = Output.all(values)
    }

    /**
     * @param value The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("jsqhwnvepskemupi")
    public suspend
    fun securityServicePolicyData(`value`: Output<PolicySecurityServicePolicyDataArgs>) {
        this.securityServicePolicyData = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("arplxsxfjmigbkus")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
     */
    @JvmName("yjkcwnwvtdkgsugm")
    public suspend fun deleteAllPolicyResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAllPolicyResources = mapped
    }

    /**
     * @param value If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
     */
    @JvmName("mwyxcihrgfiiblul")
    public suspend fun deleteUnusedFmManagedResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteUnusedFmManagedResources = mapped
    }

    /**
     * @param value The description of the AWS Network Firewall firewall policy.
     */
    @JvmName("ajqknwitmcqbidhe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("bhlwqvwpshkdjcfj")
    public suspend fun excludeMap(`value`: PolicyExcludeMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeMap = mapped
    }

    /**
     * @param argument A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("qxxhaganegurcafj")
    public suspend fun excludeMap(argument: suspend PolicyExcludeMapArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyExcludeMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.excludeMap = mapped
    }

    /**
     * @param value A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
     */
    @JvmName("psjenuwqvcbhbwmh")
    public suspend fun excludeResourceTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceTags = mapped
    }

    /**
     * @param value A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("tvenqyryiykxulmq")
    public suspend fun includeMap(`value`: PolicyIncludeMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeMap = mapped
    }

    /**
     * @param argument A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("aykkjduouqhxfkvf")
    public suspend fun includeMap(argument: suspend PolicyIncludeMapArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyIncludeMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.includeMap = mapped
    }

    /**
     * @param value The friendly name of the AWS Firewall Manager Policy.
     */
    @JvmName("urlmonrwlbxocahu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
     */
    @JvmName("vtydwhgfladahfsi")
    public suspend fun remediationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationEnabled = mapped
    }

    /**
     * @param value A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("fjxysdfrnajpriij")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param values A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("bixpycyiasldcbie")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
     */
    @JvmName("ivvxiwolqtaatftt")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("wtnjbptptcaicctw")
    public suspend fun resourceTypeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param values A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("hxhuwuxvctbrarbh")
    public suspend fun resourceTypeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param value The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("fofvcjqldjghpfgo")
    public suspend fun securityServicePolicyData(`value`: PolicySecurityServicePolicyDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityServicePolicyData = mapped
    }

    /**
     * @param argument The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("iskqehldelxyrwwm")
    public suspend
    fun securityServicePolicyData(argument: suspend PolicySecurityServicePolicyDataArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySecurityServicePolicyDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityServicePolicyData = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("tqtrrmboqomchnwy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("owitflodqhwhwfyf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        deleteAllPolicyResources = deleteAllPolicyResources,
        deleteUnusedFmManagedResources = deleteUnusedFmManagedResources,
        description = description,
        excludeMap = excludeMap,
        excludeResourceTags = excludeResourceTags,
        includeMap = includeMap,
        name = name,
        remediationEnabled = remediationEnabled,
        resourceTags = resourceTags,
        resourceType = resourceType,
        resourceTypeLists = resourceTypeLists,
        securityServicePolicyData = securityServicePolicyData,
        tags = tags,
    )
}
