@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.PolicyExcludeMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accounts A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
 * @property orgunits A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
 * You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
 */
public data class PolicyExcludeMapArgs(
    public val accounts: Output<List<String>>? = null,
    public val orgunits: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.inputs.PolicyExcludeMapArgs> {
    override fun toJava(): com.pulumi.aws.fms.inputs.PolicyExcludeMapArgs =
        com.pulumi.aws.fms.inputs.PolicyExcludeMapArgs.builder()
            .accounts(accounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .orgunits(orgunits?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PolicyExcludeMapArgs].
 */
@PulumiTagMarker
public class PolicyExcludeMapArgsBuilder internal constructor() {
    private var accounts: Output<List<String>>? = null

    private var orgunits: Output<List<String>>? = null

    /**
     * @param value A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
     */
    @JvmName("kyfrxwnubseaheum")
    public suspend fun accounts(`value`: Output<List<String>>) {
        this.accounts = value
    }

    @JvmName("ygvldkvkrofshvox")
    public suspend fun accounts(vararg values: Output<String>) {
        this.accounts = Output.all(values.asList())
    }

    /**
     * @param values A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
     */
    @JvmName("dklgfxawkilhgejp")
    public suspend fun accounts(values: List<Output<String>>) {
        this.accounts = Output.all(values)
    }

    /**
     * @param value A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
     */
    @JvmName("uelogairengcnadt")
    public suspend fun orgunits(`value`: Output<List<String>>) {
        this.orgunits = value
    }

    @JvmName("vrktwhbxxrgqvmgn")
    public suspend fun orgunits(vararg values: Output<String>) {
        this.orgunits = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
     */
    @JvmName("ssarlsolmtaavssq")
    public suspend fun orgunits(values: List<Output<String>>) {
        this.orgunits = Output.all(values)
    }

    /**
     * @param value A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
     */
    @JvmName("umejfrchfhwmjwqo")
    public suspend fun accounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param values A list of AWS Organization member Accounts that you want to include for this AWS FMS Policy.
     */
    @JvmName("sjjcgahiowllecfh")
    public suspend fun accounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accounts = mapped
    }

    /**
     * @param value A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
     */
    @JvmName("weviodrqhykjyhbb")
    public suspend fun orgunits(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orgunits = mapped
    }

    /**
     * @param values A list of IDs of the AWS Organizational Units that you want to include for this AWS FMS Policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     * You can specify inclusions or exclusions, but not both. If you specify an `include_map`, AWS Firewall Manager applies the policy to all accounts specified by the `include_map`, and does not evaluate any `exclude_map` specifications. If you do not specify an `include_map`, then Firewall Manager applies the policy to all accounts except for those specified by the `exclude_map`.
     */
    @JvmName("mgnkibaferoepttp")
    public suspend fun orgunits(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.orgunits = mapped
    }

    internal fun build(): PolicyExcludeMapArgs = PolicyExcludeMapArgs(
        accounts = accounts,
        orgunits = orgunits,
    )
}
