@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property managedServiceData Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
 * @property policyOption Contains the Network Firewall firewall policy options to configure a centralized deployment model. Documented below.
 * @property type The service that the policy is using to protect the resources. For the current list of supported types, please refer to the [AWS Firewall Manager SecurityServicePolicyData API Type Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html#fms-Type-SecurityServicePolicyData-Type).
 */
public data class PolicySecurityServicePolicyDataArgs(
    public val managedServiceData: Output<String>? = null,
    public val policyOption: Output<PolicySecurityServicePolicyDataPolicyOptionArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs> {
    override fun toJava(): com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs =
        com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs.builder()
            .managedServiceData(managedServiceData?.applyValue({ args0 -> args0 }))
            .policyOption(policyOption?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicySecurityServicePolicyDataArgs].
 */
@PulumiTagMarker
public class PolicySecurityServicePolicyDataArgsBuilder internal constructor() {
    private var managedServiceData: Output<String>? = null

    private var policyOption: Output<PolicySecurityServicePolicyDataPolicyOptionArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
     */
    @JvmName("jqplrbecaxvnkfim")
    public suspend fun managedServiceData(`value`: Output<String>) {
        this.managedServiceData = value
    }

    /**
     * @param value Contains the Network Firewall firewall policy options to configure a centralized deployment model. Documented below.
     */
    @JvmName("jytaohconpxmftdt")
    public suspend
    fun policyOption(`value`: Output<PolicySecurityServicePolicyDataPolicyOptionArgs>) {
        this.policyOption = value
    }

    /**
     * @param value The service that the policy is using to protect the resources. For the current list of supported types, please refer to the [AWS Firewall Manager SecurityServicePolicyData API Type Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html#fms-Type-SecurityServicePolicyData-Type).
     */
    @JvmName("pqyibmfbxquhpueb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
     */
    @JvmName("umenrdojqyqitrss")
    public suspend fun managedServiceData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedServiceData = mapped
    }

    /**
     * @param value Contains the Network Firewall firewall policy options to configure a centralized deployment model. Documented below.
     */
    @JvmName("ooirvyxjveuqqkny")
    public suspend fun policyOption(`value`: PolicySecurityServicePolicyDataPolicyOptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyOption = mapped
    }

    /**
     * @param argument Contains the Network Firewall firewall policy options to configure a centralized deployment model. Documented below.
     */
    @JvmName("hkyywpavlitqnnyc")
    public suspend
    fun policyOption(argument: suspend PolicySecurityServicePolicyDataPolicyOptionArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySecurityServicePolicyDataPolicyOptionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.policyOption = mapped
    }

    /**
     * @param value The service that the policy is using to protect the resources. For the current list of supported types, please refer to the [AWS Firewall Manager SecurityServicePolicyData API Type Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html#fms-Type-SecurityServicePolicyData-Type).
     */
    @JvmName("epsjghwcqkxrlcdy")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PolicySecurityServicePolicyDataArgs = PolicySecurityServicePolicyDataArgs(
        managedServiceData = managedServiceData,
        policyOption = policyOption,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
