@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property networkFirewallPolicy Defines the deployment model to use for the firewall policy. Documented below.
 * @property thirdPartyFirewallPolicy
 */
public data class PolicySecurityServicePolicyDataPolicyOptionArgs(
    public val networkFirewallPolicy:
    Output<PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs>? = null,
    public val thirdPartyFirewallPolicy:
    Output<PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionArgs> {
    override fun toJava(): com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionArgs =
        com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionArgs.builder()
            .networkFirewallPolicy(
                networkFirewallPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .thirdPartyFirewallPolicy(
                thirdPartyFirewallPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicySecurityServicePolicyDataPolicyOptionArgs].
 */
@PulumiTagMarker
public class PolicySecurityServicePolicyDataPolicyOptionArgsBuilder internal constructor() {
    private var networkFirewallPolicy:
        Output<PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs>? = null

    private var thirdPartyFirewallPolicy:
        Output<PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs>? = null

    /**
     * @param value Defines the deployment model to use for the firewall policy. Documented below.
     */
    @JvmName("hnbmkrcewwdqmkee")
    public suspend
    fun networkFirewallPolicy(`value`: Output<PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs>) {
        this.networkFirewallPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("itoekxulpcbacxxo")
    public suspend
    fun thirdPartyFirewallPolicy(`value`: Output<PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs>) {
        this.thirdPartyFirewallPolicy = value
    }

    /**
     * @param value Defines the deployment model to use for the firewall policy. Documented below.
     */
    @JvmName("ndosubxbmgvjqouv")
    public suspend
    fun networkFirewallPolicy(`value`: PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkFirewallPolicy = mapped
    }

    /**
     * @param argument Defines the deployment model to use for the firewall policy. Documented below.
     */
    @JvmName("votmyuisjjaijwww")
    public suspend
    fun networkFirewallPolicy(argument: suspend PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkFirewallPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("gfpwpesirqibbelm")
    public suspend
    fun thirdPartyFirewallPolicy(`value`: PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thirdPartyFirewallPolicy = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mrgtgxdqgyvutlho")
    public suspend
    fun thirdPartyFirewallPolicy(argument: suspend PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.thirdPartyFirewallPolicy = mapped
    }

    internal fun build(): PolicySecurityServicePolicyDataPolicyOptionArgs =
        PolicySecurityServicePolicyDataPolicyOptionArgs(
            networkFirewallPolicy = networkFirewallPolicy,
            thirdPartyFirewallPolicy = thirdPartyFirewallPolicy,
        )
}
