@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallDeploymentModel Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
 */
public data class PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs(
    public val firewallDeploymentModel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs> {
    override fun toJava():
        com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs =
        com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs.builder()
            .firewallDeploymentModel(firewallDeploymentModel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs].
 */
@PulumiTagMarker
public class PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgsBuilder internal
constructor() {
    private var firewallDeploymentModel: Output<String>? = null

    /**
     * @param value Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
     */
    @JvmName("pwciyubgueoycvwk")
    public suspend fun firewallDeploymentModel(`value`: Output<String>) {
        this.firewallDeploymentModel = value
    }

    /**
     * @param value Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
     */
    @JvmName("rroblggbeorgjojx")
    public suspend fun firewallDeploymentModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallDeploymentModel = mapped
    }

    internal fun build(): PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs =
        PolicySecurityServicePolicyDataPolicyOptionNetworkFirewallPolicyArgs(
            firewallDeploymentModel = firewallDeploymentModel,
        )
}
