@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property managedServiceData Details about the service that are specific to the service type, in JSON format. For service type `SHIELD_ADVANCED`, this is an empty string. Examples depending on `type` can be found in the [AWS Firewall Manager SecurityServicePolicyData API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html).
 * @property policyOption Contains the Network Firewall firewall policy options to configure a centralized deployment model. Documented below.
 * @property type The service that the policy is using to protect the resources. For the current list of supported types, please refer to the [AWS Firewall Manager SecurityServicePolicyData API Type Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_SecurityServicePolicyData.html#fms-Type-SecurityServicePolicyData-Type).
 */
public data class PolicySecurityServicePolicyData(
    public val managedServiceData: String? = null,
    public val policyOption: PolicySecurityServicePolicyDataPolicyOption? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fms.outputs.PolicySecurityServicePolicyData):
            PolicySecurityServicePolicyData = PolicySecurityServicePolicyData(
            managedServiceData = javaType.managedServiceData().map({ args0 -> args0 }).orElse(null),
            policyOption = javaType.policyOption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fms.kotlin.outputs.PolicySecurityServicePolicyDataPolicyOption.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
